/*
   Header file for Internet protocol headers
   --------------------------------------------------------------------
   Protolog - The Internet Protocols logger

   Copyright (C) 1998, 1999 Diego Javier Grigna <diego@grigna.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * If "unsigned char, unsigned short and unsigned long" doesn't have the
 * sizes "8, 16 and 32 bits" in your platform, then you could change it here.
 */
#define PLOG_U8   unsigned char  /* Unsigned 8  bits on ix86 */
#define PLOG_U16  unsigned short /* Unsigned 16 bits on ix86 */
#define PLOG_U32  unsigned long  /* Unsigned 32 bits on ix86 */

/*
 * IP header
 * RFC 791
 */

struct plog_iphdr {
       PLOG_U8  hlv;              /* IP header length + IP version */
       PLOG_U8  tos;              /* Type of service              */
       PLOG_U16 tot_len;          /* Total length of packet       */
       PLOG_U16 id;               /* Identification               */
       PLOG_U16 frag_off;         /* Fragmentation flags & offset */
       PLOG_U8  ttl;              /* Time To Live                 */
       PLOG_U8  protocol;         /* Protocol                     */
       PLOG_U16 check;            /* Checksum                     */
       PLOG_U32 saddr;            /* Source address               */
       PLOG_U32 daddr;            /* Destination address          */
};

/* TCP flags masks */

#define PLOG_TH_URG  0x20
#define PLOG_TH_ACK  0x10
#define PLOG_TH_PSH  0x08
#define PLOG_TH_RST  0x04
#define PLOG_TH_SYN  0x02
#define PLOG_TH_FIN  0x01

/*
 * TCP header
 * RFC 793
 */

struct plog_tcphdr {
       PLOG_U16 th_sport;  /* Source port            */
       PLOG_U16 th_dport;  /* Destination port       */
       PLOG_U32 th_seq;    /* Sequence number        */
       PLOG_U32 th_ack;    /* Acknowledgement number */
       PLOG_U8  th_do;     /* Data offset + reserved */
       PLOG_U8  th_flags;  /* Flags                  */
       PLOG_U16 th_win;    /* Window size            */
       PLOG_U16 th_sum;    /* Checksum               */
       PLOG_U16 th_urp;    /* Urgent pointer         */
};


/*
 * UDP header
 * RFC 768
 */

struct plog_udphdr {
       PLOG_U16 source;
       PLOG_U16 dest;
       PLOG_U16 len;
       PLOG_U16 check;
};


/*
 * ICMP header
 * RFC 792
 */

struct plog_icmphdr {
  PLOG_U8  type;
  PLOG_U8  code;
  PLOG_U16 checksum;
  union {
        struct {
                PLOG_U16 id;
                PLOG_U16 sequence;
        } echo;
        PLOG_U32 gateway;
        PLOG_U32 unused;
        PLOG_U32 reserved;
        PLOG_U32 routad;  /* Router advertisement fields */
        PLOG_U8 pointer;  /* For parameter problem */
  } un;
};

