/*****************************************************************************/
/*
                                 Query.c


A CGI-compliant script to search plain-text and HTML files.


QUALIFIERS
----------
/ABOUT=                 URL for help on searching
/DBUG                   turns on all "if (Debug)" statements
/HTML=                  list of comma separated HTML file types
/TEXT=                  list of comma separated TEXT file types


BUILD DETAILS
-------------
See BUILD_QUERY.COM procedure.


VERSION HISTORY (update SoftwareID as well!)
---------------
19-FEB-97  MGD  v2.3.2, bugfix; "&hits=document" nexting,
                        modified "?about=search" redirection
19-AUG-97  MGD  v2.3.1, MapUrl() to MapUrl_Map() for conditional mapping
23-MAY-97  MGD  v2.3.0, wildcard search,
                        un-escape character entities (e.g. "&lt;") before match
19-SEP-95  MGD  v2.2.1, replace <CR><LF> carriage-control with single newline,
                        still acceptable for HTTP, and slightly more efficient
24-MAY-95  MGD  v2.2.0, minor changes for AXP compatibility
21-APR-95  MGD  v2.1.1, added 'FormWhat'
27-MAR-95  MGD  v2.1.0, modifications to CGI interface
05-DEC-94  MGD  v2.0.0, major revision, URL mapping, CGI-like interface
10-JUN-94  MGD  v1.0.0, initial development
*/
/*****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [] = "QUERY AXP-2.3.2";
#else
   char SoftwareID [] = "QUERY VAX-2.3.2";
#endif

/* standard C header files */
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

/* VMS-related header files */
#include <descrip.h>
#include <libdef.h>
#include <rmsdef.h>
#include <rms.h>
#include <ssdef.h>
#include <stsdef.h>

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#define boolean int
#define true 1
#define false 0
 
#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))

#define DefaultExtractNumberOfRecords 20

char  ExtractScriptName [] = "extract";

char  Utility [] = "QUERY";

char  Http200Header [] =
"HTTP/1.0 200 Document follows.\n\
Content-Type: text/html\n\
\n";

char  Http404Header [] =
"HTTP/1.0 404 Error report follows.\n\
Content-Type: text/html\n\
\n";

boolean  Debug,
         ExactNumberOfRecords,
         HttpHasBeenOutput;

int  ExtractNumberOfRecords;

char  AboutUrl [256],
      CgiPathInfo [256],
      CgiPathTranslated [256],
      CgiQueryString [256],
      CgiRequestMethod [32],
      CgiServerName [128],
      CgiServerPort [128],
      CgiScriptName [256],
      FormAbout [16],
      FormCase [16],
      FormExact [16],
      FormExtract [16],
      FormHits [16],
      FormSearch [256],
      KeyCount [16],
      FormWhat [256],
      KeyName [16],
      KeyValue [256],
      HtmlFileTypes [256],
      TextFileTypes [256];
      
FILE  *HttpOut;

/*****************************************************************************/
/*
*/

main (int argc, char *argv[])

{
   register int  acnt;
   register char  *cptr, *sptr;

   boolean  CaseSensitive = false,
            DocumentOnly = false;
   int  status,
        Count,
        CgiPathTranslatedLength;

   /*********/
   /* begin */
   /*********/

   if (getenv ("QUERY$DBUG") != NULL) Debug = true;

   if (Debug)
      system ("show sym *");
   else
   {
      /* reopen output stream so that the '\r' and '\n' are not filtered */
#ifdef __DECC
      if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "ctx=bin")) == NULL)
         exit (vaxc$errno);
#else
      if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "rfm=udf")) == NULL)
         exit (vaxc$errno);
#endif
   }
   HttpOut = stdout;

   /***********************************/
   /* get the command line parameters */
   /***********************************/

   for (acnt = 1; acnt < argc; acnt++)
   {
      if (Debug) fprintf (stdout, "argv[%d] |%s|\n", acnt, argv[acnt]);
      if (strsame (argv[acnt], "/ABOUT=", 3))
      {
         for (cptr = argv[acnt]+4; *cptr && *cptr != '='; cptr++);
         if (*cptr) cptr++;
         sptr = AboutUrl;
         while (*cptr) *sptr++ = *cptr++;
         *sptr = '\0';
         continue;
      }
      if (strsame (argv[acnt], "/DBUG", -1))
      {
         Debug = true;
         continue;
      }
      if (strsame (argv[acnt], "/HTML=", 5))
      {
         for (cptr = argv[acnt]+4; *cptr && *cptr != '='; cptr++);
         if (*cptr) cptr++;
         sptr = HtmlFileTypes;
         while (*cptr) *sptr++ = toupper(*cptr++);
         *sptr = '\0';
         continue;
      }
      if (strsame (argv[acnt], "/TEXT=", 5))
      {
         for (cptr = argv[acnt]+4; *cptr && *cptr != '='; cptr++);
         if (*cptr) cptr++;
         sptr = TextFileTypes;
         while (*cptr) *sptr++ = toupper(*cptr++);
         *sptr = '\0';
         continue;
      }
      fprintf (stdout, "%%%s-E-IVQUAL, unrecognized qualifier\n \\%s\\\n",
               Utility, argv[acnt]+1);
      exit (STS$K_ERROR | STS$M_INHIB_MSG);
   }

   if (Debug)
      fprintf (stdout,
               "HtmlFileTypes |%s|\nTextFileTypes |%s|\n",
               HtmlFileTypes, TextFileTypes);
   if (!HtmlFileTypes[0] || !TextFileTypes[0])
   {
      ErrorGeneral ("File extensions not configured.", __FILE__, __LINE__);
      exit (SS$_NORMAL);
   }

   /*************************/
   /* get the CGI variables */
   /*************************/

   GetCgiVariable ("WWW_SERVER_NAME", CgiServerName, sizeof(CgiServerName));
   GetCgiVariable ("WWW_PATH_INFO", CgiPathInfo, sizeof(CgiPathInfo));
   CgiPathTranslatedLength =
      GetCgiVariable ("WWW_PATH_TRANSLATED",
                      CgiPathTranslated, sizeof(CgiPathTranslated));
   GetCgiVariable ("WWW_QUERY_STRING", CgiQueryString, sizeof(CgiQueryString));
   GetCgiVariable ("WWW_REQUEST_METHOD", CgiRequestMethod,
                   sizeof(CgiRequestMethod));
   GetCgiVariable ("WWW_SCRIPT_NAME", CgiScriptName, sizeof(CgiScriptName));

   FormAbout[0] = FormExact[0] = FormExtract[0] = FormSearch[0] =
      FormHits[0] = KeyCount[0] = '\0';
   GetCgiVariable ("WWW_FORM_ABOUT", FormAbout, sizeof(FormAbout));
   GetCgiVariable ("WWW_FORM_CASE", FormCase, sizeof(FormCase));
   GetCgiVariable ("WWW_FORM_EXACT", FormExact, sizeof(FormExact));
   GetCgiVariable ("WWW_FORM_EXTRACT", FormExtract, sizeof(FormExtract));
   GetCgiVariable ("WWW_FORM_HITS", FormHits, sizeof(FormHits));
   GetCgiVariable ("WWW_FORM_SEARCH", FormSearch, sizeof(FormSearch));
   GetCgiVariable ("WWW_FORM_WHAT", FormWhat, sizeof(FormWhat));
   GetCgiVariable ("WWW_KEY_COUNT",  KeyCount, sizeof(KeyCount));

   Count = atoi(KeyCount);
   for (acnt = 1; acnt <= Count; acnt++)
   {
      sprintf (KeyName, "WWW_KEY_%d", acnt);
      GetCgiVariable (KeyName,  KeyValue, sizeof(KeyValue));
      if (FormSearch[0]) strcat (FormSearch, " ");
      strcat (FormSearch, KeyValue);
   }

   /***********/
   /* process */
   /***********/

   /* numeric equivalent of "GET\0" (just a bit more efficient, that's all!) */
   if (*(unsigned long*)CgiRequestMethod != 0x00544547) exit (SS$_NORMAL);

   if (strsame (FormAbout, "SEARCH", 6))
   {
/*
      GetCgiVariable ("WWW_SERVER_PORT", CgiServerPort, sizeof(CgiServerPort));
      fprintf (HttpOut,
"HTTP/1.0 302 Redirection.\n\
Location: http://%s:%s%s\n\
\n",
      CgiServerName, CgiServerPort, AboutUrl);
*/
      fprintf (HttpOut, "Location: %s\n\n", AboutUrl);
      exit (SS$_NORMAL);
   }

   if (!CgiPathInfo[0])
   {
      ErrorGeneral ("Search path not supplied.", __FILE__, __LINE__);
      exit (SS$_NORMAL);
   }
   if (!FormSearch[0])
   {
      ErrorGeneral ("Search string not supplied.", __FILE__, __LINE__);
      exit (SS$_NORMAL);
   }
   if (FormExtract[0] && !isdigit(FormExtract[0]))
   {
      ErrorGeneral ("Invalid number of lines to extract.",
                    __FILE__, __LINE__);
      exit (SS$_NORMAL);
   }

   ExtractNumberOfRecords = atoi(FormExtract);
   if (!ExtractNumberOfRecords)
      ExtractNumberOfRecords = DefaultExtractNumberOfRecords;

   if (toupper(FormExact[0]) == 'Y')
      ExactNumberOfRecords = true;
   else
      ExactNumberOfRecords = false;

   if (toupper(FormCase[0]) == 'Y')
      CaseSensitive = true;
   else
      CaseSensitive = false;

   if (toupper(FormHits[0]) == 'D')
      DocumentOnly = true;
   else
      DocumentOnly = false;

   SearchFiles (CgiPathTranslated, CgiPathTranslatedLength,
                FormSearch, CaseSensitive, DocumentOnly);

   fclose (HttpOut);

   exit (SS$_NORMAL);
}

/*****************************************************************************/
/*
Get the contents of the DCL symbol corresponding to the 'VariableName'.
*/

int GetCgiVariable
(
char *VariableName,
char *VariableValue,
int VariableValueSize
)
{
   static $DESCRIPTOR (VariableNameDsc, "");
   static $DESCRIPTOR (VariableValueDsc, "");

   register int  status;

   unsigned short  Length;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "GetCgiVariable() |%s|\n", VariableName);

   VariableNameDsc.dsc$w_length = strlen(VariableName);
   VariableNameDsc.dsc$a_pointer = VariableName;
   VariableValueDsc.dsc$w_length = VariableValueSize-1;
   VariableValueDsc.dsc$a_pointer = VariableValue;

   if (VMSok (status =
       lib$get_symbol (&VariableNameDsc, &VariableValueDsc, &Length, 0)))
      VariableValue[Length] = '\0';
   else
      VariableValue[0] = '\0';

   if (status == LIB$_NOSUCHSYM) return (-1);
   if (VMSnok (status))
   {
      if (Debug) fprintf (stdout, "lib$get_symbol() %%X%08.08X\n", status);
      exit (status);
   }
   if (Debug) fprintf (stdout, "|%s|\n", VariableValue);
   return (Length);
}

/*****************************************************************************/
/*
*/

ErrorGeneral
(
char *Text,
char *SourceFileName,
int SourceLineNumber
)
{
   register char  *cptr;

   /*********/
   /* begin */
   /*********/

   /* 
      The source file format provided by the "__FILE__" macro will be
      "device:[directory]name.type;ver".  Reduce that to "name.type".
   */
   for (cptr = SourceFileName; *cptr && *cptr != ';'; cptr++);
   if (*cptr)
   {
      while (*cptr != '.') cptr--;
      *cptr-- = '\0';
   }
   while (*cptr != ']') cptr--;
   cptr++;

   if (!HttpHasBeenOutput) fputs (Http404Header, HttpOut);
   fprintf (HttpOut,
"<!-- SoftwareID: %s Module: %s Line: %d -->\n\
<H1>ERROR!</H1>\n\
<P>Reported by server.\n\
<P>%s\n",
   SoftwareID, cptr, SourceLineNumber, Text);
}

/*****************************************************************************/
/*
*/

ErrorVmsStatus
(
int StatusValue,
char *Text,
char *HiddenText,
char *SourceFileName,
int SourceLineNumber
)
{
   static char  Message [256];
   static $DESCRIPTOR (MessageDsc, Message);

   register char  *cptr;
   int  status;
   short int  Length;

   /*********/
   /* begin */
   /*********/

   if (VMSok (status = sys$getmsg (StatusValue, &Length, &MessageDsc, 1, 0))) 
   {
      Message[Length] = '\0';
      Message[0] = toupper(Message[0]);
   }
   else
      exit (status);

   /* 
      The source file format provided by the "__FILE__" macro will be
      "device:[directory]name.type;ver".  Reduce that to "name.type".
   */
   for (cptr = SourceFileName; *cptr && *cptr != ';'; cptr++);
   if (*cptr)
   {
      while (*cptr != '.') cptr--;
      *cptr-- = '\0';
   }
   while (*cptr != ']') cptr--;
   cptr++;

   if (!HttpHasBeenOutput) fputs (Http404Header, HttpOut);
   fprintf (HttpOut,
"<!-- SoftwareID: %s Module: %s Line: %d -->\n\
<H1>ERROR!</H1>\n\
<P>Reported by server.\n\
<P>%s ... <TT>%s</TT>\n\
<!-- %%X%08.08X \"%s\" -->\n",
   SoftwareID, cptr, SourceLineNumber, Message, Text, StatusValue, HiddenText);
}

/****************************************************************************/
/*
Does a case-insensitive, character-by-character string compare and returns 
true if two strings are the same, or false if not.  If a maximum number of 
characters are specified only those will be compared, if the entire strings 
should be compared then specify the number of characters as 0.
*/ 

boolean strsame
(
register char *sptr1,
register char *sptr2,
register int  count
)
{
   while (*sptr1 && *sptr2)
   {
      if (toupper (*sptr1++) != toupper (*sptr2++)) return (false);
      if (count)
         if (!--count) return (true);
   }
   if (*sptr1 || *sptr2)
      return (false);
   else
      return (true);
}

/*****************************************************************************/

