/*****************************************************************************/
/*
                               SearchFiles.c


VERSION HISTORY
---------------
19-AUG-97  MGD  MapUrl() to MapUrl_Map() for conditional mapping
23-MAY-97  MGD  wildcard search
31-AUG-95  MGD  bugfix; correctly report when no files at all are found
21-APR-95  MGD  added 'FormWhat'
05-DEC-94  MGD  minor revisions
10-JUN-94  MGD  initial development
*/
/*****************************************************************************/

/* standard C header files */
#include <stdio.h>
#include <ctype.h>

/* VMS related header files */
#include <descrip.h>
#include <rmsdef.h>
#include <rms.h>
#include <ssdef.h>
#include <stsdef.h>

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#define boolean int
#define true 1
#define false 0
 
#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))

/* external declarations */
extern boolean  Debug;
extern boolean  ExactNumberOfRecords;
extern boolean  HttpHasBeenOutput;
extern int  ExtractNumberOfRecords;
extern char  CgiPathInfo[];
extern char  FormWhat[];
extern char  HtmlFileTypes[];
extern char  Http200Header[];
extern char  SoftwareID[];
extern char  TextFileTypes[];
extern FILE  *HttpOut;

char* MapUrl_Map (char*, char*, char*, char*, void*);

/*****************************************************************************/
/*
Search files in specification for specified string.  Unless a file type 
(extension) matches an HTML type then consider the file to be a plain-text 
file.  The two need to searched differently because of the HTML markup tags 
compsrising an HTML file.
*/ 

SearchFiles
(
char *FileSpec,
int FileSpecLength,
char *SearchString,
boolean CaseSensitive,
boolean DocumentOnly
)
{
   static int  TimerElapsed = 1,
               TimerCpu = 2,
               TimerBio = 3,
               TimerDio = 4;
   static $DESCRIPTOR (ElapsedTimeFaoDsc, "!%T");
   static $DESCRIPTOR (StatisticsFaoDsc,
"Elapsed: <TT>!AZ</TT> CPU: <TT>!2ZL.!UL</TT> \
I/O: <TT>!UL</TT> Disk: <TT>!UL</TT> Records (lines) : <TT>!UL</TT>");

   int  status,
        BioCount,
        CpuTime,
        DioCount,
        FileCount = 0,
        FileHitCount = 0,
        NotSearchedFileCount = 0,
        TotalHitCount = 0,
        RecordCount = 0,
        SearchStringLength;
   unsigned long  ElapsedTime [2];
   unsigned short  Length;
   char  *FilePtr,
         *FileHitPtr,
         *TotalHitPtr;
   char  DocumentName [2048],
         ElapsedString [32],
         ExpandedFileSpec [256],
         FileName [256],
         NotSearchedString [32],
         Statistics [256],
         String [256],
         UriSearchString [256];
   struct FAB  SearchFab;
   struct NAM  SearchNam;
   $DESCRIPTOR (ElapsedStringDsc, ElapsedString);
   $DESCRIPTOR (StatisticsDsc, Statistics);

   /*********/
   /* begin */
   /*********/

   if (Debug)
      fprintf (stdout, "SearchFiles() |%s|%s|\n", FileSpec, UriSearchString);

   lib$init_timer (0);

   if (SearchString[0])
   {
      SearchStringLength = strlen(SearchString);
      CopyTextIntoUri (UriSearchString, SearchString, -1);
   }
   else
   {
      SearchStringLength = 0;
      UriSearchString[0] = '\0';
   }

   fprintf (HttpOut,
"%s\
<HTML>\n\
<!-- SoftwareID: %s -->\n",
   Http200Header, SoftwareID);

   if (FormWhat[0])
      fprintf (HttpOut, "<TITLE>Search %s for \"", FormWhat);
   else
      fprintf (HttpOut, "<TITLE>Search for \"");
   CopyTextIntoHtml (String, SearchString, -1);
   fputs (String, HttpOut);
   fputs ("\"</TITLE>\n", HttpOut);
   if (FormWhat[0])
      fprintf (HttpOut, "<H1>Search <TT>%s</TT> for \"<TT>", FormWhat);
   else
      fprintf (HttpOut, "<H1>Search %s for \"<TT>", FormWhat);
   CopyTextIntoHtml (String, SearchString, -1);
   fputs (String, HttpOut);
   fputs ("</TT>\"</H1>\n<P><HR SIZE=3>\n", HttpOut);
   fflush (HttpOut);
   HttpHasBeenOutput = true;

   SearchFab = cc$rms_fab;
   SearchFab.fab$l_fna = FileSpec;
   SearchFab.fab$b_fns = FileSpecLength;
   SearchFab.fab$l_fop = FAB$M_NAM;
   SearchFab.fab$l_nam = &SearchNam;
   SearchNam = cc$rms_nam;
   SearchNam.nam$l_esa = ExpandedFileSpec;
   SearchNam.nam$b_ess = sizeof(ExpandedFileSpec)-1;
   SearchNam.nam$l_rsa = FileName;
   SearchNam.nam$b_rss = sizeof(FileName)-1;

   if (VMSnok (status = sys$parse (&SearchFab, 0, 0)))
   {
      ErrorVmsStatus (status, CgiPathInfo, FileSpec, __FILE__, __LINE__);
      return (status);
   }

   if (Debug) fprintf (stdout, "ExpandedFileSpec |%s|\n", ExpandedFileSpec);

   /***************/
   /* file search */
   /***************/

   while (VMSok (status = sys$search (&SearchFab, 0, 0)))
   {
      *SearchNam.nam$l_ver = '\0';
      if (Debug) fprintf (stdout, "FileName |%s|\n", FileName);

      if (SameFileType (HtmlFileTypes, SearchNam.nam$l_type))
      {
         FileCount++;
         /* if HTML document's <title> can't be resolved then use file name */
         sprintf (DocumentName, "(file name) %s", SearchNam.nam$l_name);

         status = SearchHtmlFile (FileName, SearchNam.nam$l_ver-FileName,
                                  DocumentName,
                                  UriSearchString,
                                  SearchString, SearchStringLength,
                                  &RecordCount, &FileHitCount, &TotalHitCount,
                                  CaseSensitive, DocumentOnly);
         if (VMSnok (status))
         {
            ErrorVmsStatus (status, MapUrl_Map(NULL,FileName,NULL,NULL,NULL),
                            FileName, __FILE__, __LINE__);
            return (SS$_NORMAL);
         }
         else;
      }
      else
      if (SameFileType (TextFileTypes, SearchNam.nam$l_type))
      {
         FileCount++;
         DocumentName[0] = '\0';

         status =
         SearchTextFile (FileName, SearchNam.nam$l_ver-FileName,
                         DocumentName,
                         UriSearchString,
                         SearchString, SearchStringLength,
                         &RecordCount, &FileHitCount, &TotalHitCount,
                         CaseSensitive, DocumentOnly,
                         ExtractNumberOfRecords, ExactNumberOfRecords);
         if (VMSnok (status))
         {
            ErrorVmsStatus (status, MapUrl_Map(NULL,FileName,NULL,NULL,NULL),
                            FileName, __FILE__, __LINE__);
            return (SS$_NORMAL);
         }
         else;
      }
      else
         NotSearchedFileCount++;

      *SearchNam.nam$l_ver = ';';
   }

   if (Debug) fprintf (stdout, "sys$search() %%X%08.08X\n", status);

   /*******************/
   /* end file search */
   /*******************/

   /* if its a search list treat directory not found as if file not found */
   if ((SearchNam.nam$l_fnb & NAM$M_SEARCH_LIST) && status == RMS$_DNF)
      status = RMS$_FNF;
   if (status == RMS$_FNF || status == RMS$_NMF) status = SS$_NORMAL;
   if (VMSnok (status))
   {
       ErrorVmsStatus (status, CgiPathInfo, FileSpec, __FILE__, __LINE__);
       return (SS$_NORMAL);
   }

   /*********************/
   /* results of search */
   /*********************/

   lib$stat_timer (&TimerElapsed, &ElapsedTime, 0);
   lib$stat_timer (&TimerCpu, &CpuTime, 0);
   lib$stat_timer (&TimerBio, &BioCount, 0);
   lib$stat_timer (&TimerDio, &DioCount, 0);

   sys$fao (&ElapsedTimeFaoDsc, &Length, &ElapsedStringDsc, &ElapsedTime);
   ElapsedString[Length] = '\0';
   sys$fao (&StatisticsFaoDsc, &Length, &StatisticsDsc,
            ElapsedString+3, CpuTime/100, CpuTime%100,
            BioCount, DioCount, RecordCount);
   Statistics[Length] = '\0';

   if (!NotSearchedFileCount)
      NotSearchedString[0] = '\0';
   else
   if (NotSearchedFileCount == 1)
      strcpy (NotSearchedString, " (1 not)");
   else
      sprintf (NotSearchedString, " (%d not)", NotSearchedFileCount);

   if (TotalHitCount)
   {
      if (FileCount == 1) FilePtr = "file"; else FilePtr = "files";
      if (FileHitCount == 1) FileHitPtr = "file"; else FileHitPtr = "files";
      if (TotalHitCount == 1) TotalHitPtr = "hit"; else TotalHitPtr = "hits";
      if (DocumentOnly)
      {
         fprintf (HttpOut,
"</OL>\n\
<P><HR SIZE=3>\n\
<I>%d %s searched%s with %d %s hit.\n\
<BR>%s</I>\n",
         FileCount, FilePtr, NotSearchedString, FileHitCount, FileHitPtr,
         Statistics);
      }
      else
      {
         fprintf (HttpOut,
"</OL>\n\
<P><HR SIZE=3>\n\
<I>%d %s searched%s with %d %s hit, for a total of %d %s.\n\
<BR>%s</I>\n",
         FileCount, FilePtr, NotSearchedString, FileHitCount, FileHitPtr,
         TotalHitCount, TotalHitPtr,
         Statistics);
      }
   }

   /*
       This cannot be an 'else' statement.
       Something wierd after change of carriage-control from '\r\n' to '\n',
       and, unfortunately, after update to DEC C v5.0 (so I don't know which
       caused it!)
       If it is an else the module access violates!
   */
   if (!TotalHitCount)
   {
      if (FileCount)
      {
         if (FileCount == 1) FilePtr = "file"; else FilePtr = "files";
         fprintf (HttpOut,
"<P><HR SIZE=3>\n\
<I>%d %s searched%s, string not found.\n\
<BR>%s</I>\n",
         FileCount, FilePtr, NotSearchedString,
         Statistics);
      }
      else
         fprintf (HttpOut, "<P><HR SIZE=3>\n<I>No files found.\n<BR>%s</I>\n",
                  Statistics);
   }

   if (VMSnok (status))
   {
       ErrorVmsStatus (status, CgiPathInfo, FileName, __FILE__, __LINE__);
       return (SS$_NORMAL);
   }

   fputs ("</HTML>\n", HttpOut);

   return (status);
}

/*****************************************************************************/
/*
This function accepts a comma-separated list of file types (extensions, e.g.
"TXT,TEXT,COM,C,PAS,FOR") and a VMS file type (e.g. ".TXT;", ".TXT", "TXT").
It returns true if the file type is in the list, false if not.
*/

boolean SameFileType
(
char *TypeList,
char *FileType
)
{
   register char  *cptr, *sptr;

   /*********/
   /* begin */
   /*********/

   if (Debug)
      fprintf (stdout, "SameFileType() |%s|%s|\n", TypeList, FileType);

   if (*FileType == '.') FileType++;
   cptr = TypeList;
   while (*cptr)
   {
      sptr = FileType;
      while (*sptr && *sptr != ';' && *cptr && *cptr != ',' &&
             toupper(*sptr) == toupper(*cptr))
      {
         cptr++;
         sptr++;
      }
      if ((!*sptr || *sptr == ';') && (!*cptr || *cptr == ',')) return (true);
      while (*cptr && *cptr != ',') cptr++;
      if (*cptr) cptr++;
   }
   return (false);
}

/*****************************************************************************/
/*
String search allowing wildcard "*" (matching any multiple characters) and "%" 
(matching any single character).  Returns NULL if not found or a pointer to
start of matched string.
*/ 

char* SearchTextString
( 
register char *InThat,
register char *This,
register boolean CaseSensitive,
int *MatchedLengthPtr
)
{
/* wildcards implied at both ends of the search string */
#define IMPLIED_WILDCARDS 1

   register char  *cptr, *sptr, *inptr;
   char  *RestartCptr,
         *RestartInptr,
         *MatchPtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SearchTextString()\n|%s|%s|\n", This, InThat);

   if (MatchedLengthPtr != NULL) *MatchedLengthPtr = 0;
   if (!*(cptr = This)) return (NULL);
   inptr = MatchPtr = InThat;

#if IMPLIED_WILDCARDS
   /* skip leading text up to first matching character (if any!) */
   if (*cptr != '*' && *cptr != '%')
   {
      if (CaseSensitive)
         while (*inptr && *inptr != *cptr) inptr++;
      else
         while (*inptr && toupper(*inptr) != toupper(*cptr)) inptr++;
      if (Debug && !*inptr) fprintf (stdout, "1. NOT matched!\n");
      if (!*inptr) return (NULL);
      cptr++;
      MatchPtr = inptr++;
   }
#endif /* IMPLIED_WILDCARDS */

   for (;;)
   {
      if (CaseSensitive)
      {
         while (*cptr && *inptr && *cptr == *inptr)
         {
            cptr++;
            inptr++;
         }
      }
      else
      {
         while (*cptr && *inptr && toupper(*cptr) == toupper(*inptr))
         {
            cptr++;
            inptr++;
         }
      }

#if IMPLIED_WILDCARDS
      if (!*cptr)
      {
         if (Debug) fprintf (stdout, "1. matched!\n");
         if (MatchedLengthPtr != NULL) *MatchedLengthPtr = inptr - MatchPtr;
         return (MatchPtr);
      }
#else
      if (!*cptr && !*inptr)
      {
         if (Debug) fprintf (stdout, "2. matched!\n");
         if (MatchedLengthPtr != NULL) *MatchedLengthPtr = inptr - MatchPtr;
         return (MatchPtr);
      }
      else
      if (*cptr != '*' && *cptr != '%')
         return (NULL);
#endif /* IMPLIED_WILDCARDS */

      if (Debug && !*inptr) fprintf (stdout, "3. NOT matched!\n");
      if (!*inptr) return (NULL);

      if (*cptr != '*' && *cptr != '%')
      {
         cptr = This;
         MatchPtr = ++inptr;
         continue;
      }

      if (*cptr == '%')
      {
         /* single char wildcard processing */
         if (!*inptr) break;
         cptr++;
         inptr++;
         continue;
      }

      /* asterisk wildcard matching */
      while (*cptr == '*') cptr++;

      /* an asterisk wildcard at end matches all following */
      if (!*cptr)
      {
         if (Debug) fprintf (stdout, "4. matched!\n");
         while (*inptr) inptr++;
         if (MatchedLengthPtr != NULL) *MatchedLengthPtr = inptr - MatchPtr;
         return (MatchPtr);
      }

      /* note the current position in the string (first after the wildcard) */
      RestartCptr = cptr;
      for (;;)
      {
         /* find first char in InThat matching char after wildcard */
         if (CaseSensitive)
            while (*inptr && *cptr != *inptr) inptr++;
         else
            while (*inptr && toupper(*cptr) != toupper(*inptr)) inptr++;
         /* if did not find matching char in InThat being searched */
         if (Debug && !*inptr) fprintf (stdout, "5. NOT matched!\n");
         if (!*inptr) return (NULL);
         /* note the current position in InThat being searched */
         RestartInptr = inptr;
         /* try to match the remainder of the string and InThat */
         if (CaseSensitive)
         {
            while (*cptr && *inptr && *cptr == *inptr)
            {
               cptr++;
               inptr++;
            }
         }
         else
         {
            while (*cptr && *inptr && toupper(*cptr) == toupper(*inptr))
            {
               cptr++;
               inptr++;
            }
         }
         /* if reached the end of both string and InThat - match! */
#if IMPLIED_WILDCARDS
         if (!*cptr)
         {
            if (Debug) fprintf (stdout, "6. matched!\n");
            if (MatchedLengthPtr != NULL) *MatchedLengthPtr = inptr - MatchPtr;
            return (MatchPtr);
         }
#else
         if (!*cptr && !*inptr)
         {
            if (Debug) fprintf (stdout, "7. matched!\n");
            if (MatchedLengthPtr != NULL) *MatchedLengthPtr = inptr - MatchPtr;
            return (MatchPtr);
         }
#endif /* IMPLIED_WILDCARDS */
         /* break to the external loop if we encounter another wildcard */
         if (*cptr == '*' || *cptr == '%') break;
         /* lets have another go */
         cptr = RestartCptr;
         /* starting the character following the previous attempt */
         inptr = MatchPtr = RestartInptr + 1;
      }
   }
}

/*****************************************************************************/

#ifdef ORIGINAL_SEARCH

/*
Case sensitive or case insensitive search of the string pointed to by 'sptr' 
for the string pointed to by 'SearchString'.
*/ 

char* SearchTextString
( 
register char *tptr,
register char *SearchString,
register boolean CaseSensitive
)
{
   register char  *cptr, *sptr;

   sptr = SearchString;
   if (CaseSensitive)
   {
      while (*tptr)
      {
         if (*tptr++ != *sptr) continue;
         /* first character of search string matched record character */
         sptr++;
         cptr = tptr;
         while (*cptr && *sptr)
         {
            if (*cptr != *sptr) break;
            cptr++;
            sptr++;
         }
         if (!*sptr)
         {
            tptr--;
            break;
         }
         sptr = SearchString;
      }
   }
   else
   {
      while (*tptr)
      {
         if (toupper(*tptr++) != toupper(*sptr)) continue;
         /* first character of search string matched record character */
         sptr++;
         cptr = tptr;
         while (*cptr && *sptr)
         {
            if (toupper(*cptr) != toupper(*sptr)) break;
            cptr++;
            sptr++;
         }
         if (!*sptr)
         {
            tptr--;
            break;
         }
         sptr = SearchString;
      }
   }
   return (tptr);
}

#endif /* ORIGINAL_SEARCH */

/*****************************************************************************/

