/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

#include <sys/types.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <unistd.h>
#ifdef __FreeBSD__
#include <stdlib.h>
#else
#include <malloc.h>
#endif
#include <memory.h>
#include "chario.h"
#include "macros.h"
#include "services.h"
#include "classes.h"
#include "groups.h"

int nextid = 1;

struct classtable {
     struct classtable *next;
     int id;
     int hash;
     struct classentry src_in[CLASS_SIZE];
     struct classentry dst_in[CLASS_SIZE];
     struct classentry dst_out[CLASS_SIZE];
     struct classentry udp_in[CLASS_SIZE];
     struct classentry icmp_in[CLASS_SIZE];
};

struct classtable *classlist = (struct classtable *)0;

static int maxclasslen = 0;
static int minclasslen = CLASS_SIZE;
static int totclasslen = 0;
static int totclasses = 0;

void
writeclassestable(int fd)
{
     struct classentry table[5][CLASS_TABLE_SIZE][CLASS_SIZE];
     struct classtable *rove;

     memset(table, 0, sizeof(table));
     if(locate_group("default")){
	  struct classentry in_src[CLASS_SIZE];
	  struct classentry in_dst[CLASS_SIZE];
	  struct classentry out_dst[CLASS_SIZE];
	  struct classentry udp_in[CLASS_SIZE];
	  struct classentry icmp_in[CLASS_SIZE];

	  push_group("default");
	  gen_class(in_src, in_dst, out_dst, udp_in, icmp_in);
	  destroy_all_services();
	  memcpy(table[0][0], in_dst,
		 sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(table[1][0], out_dst,
		 sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(table[2][0], in_src,
		 sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(table[3][0], udp_in,
		 sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(table[4][0], icmp_in,
		 sizeof(struct classentry)*CLASS_SIZE);
     }
     printf("%d class%s (min/avg/max = %d/%d/%d)\n", nextid-1,
	    (nextid-1 == 1) ? "" : "es",
	    minclasslen, (totclasslen+(totclasses/2))/totclasses, maxclasslen);
     for(rove=classlist;rove;rove=rove->next){
	  memcpy(table[0][rove->id], rove->dst_in,
		 sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(table[1][rove->id], rove->dst_out,
		 sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(table[2][rove->id], rove->src_in,
		 sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(table[3][rove->id], rove->udp_in,
		 sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(table[4][rove->id], rove->icmp_in,
		 sizeof(struct classentry)*CLASS_SIZE);
     }

     {
          int x, y, z;
          unsigned short p;

	  for(x=0;x<5;x++) {
	       for(y=0;y<CLASS_TABLE_SIZE;y++)
                    for(z=0;z<CLASS_SIZE;z++){
                          p = htons(table[x][y][z].start);
			  table[x][y][z].start = p;
                          p = htons(table[x][y][z].end);
			  table[x][y][z].end = p;
                    }
          }
	  write(fd,table,sizeof(table));
     }
}
     
static int
comphash(struct classentry src_in[CLASS_SIZE],
	 struct classentry dst_out[CLASS_SIZE],
	 struct classentry dst_in[CLASS_SIZE])
{
     int i;
     int hash;

     hash = 0;

     for(i=0;i<CLASS_SIZE;i++){
	  hash += src_in[i].start + src_in[i].end;
	  hash &= 0x00FFFFFF;
	  hash += dst_out[i].start + dst_out[i].end;
	  hash &= 0x00FFFFFF;
	  hash += dst_in[i].start + dst_in[i].end;
	  hash &= 0x00FFFFFF;
     }
     return hash;
}

static int
locate_class(struct classentry src_in[CLASS_SIZE],
	     struct classentry dst_in[CLASS_SIZE],
	     struct classentry dst_out[CLASS_SIZE],
	     struct classentry udp_in[CLASS_SIZE],
	     struct classentry icmp_in[CLASS_SIZE])
{
     struct classtable *rove;
     int match = 0;

     int hash = comphash(src_in, dst_out, dst_in);

     for(rove=classlist;rove;rove=rove->next)
	  if(hash == rove->hash){
	       int i;
	       match = 1;
	       for(i=0;i<CLASS_SIZE;i++){
		    if(rove->src_in[i].start != src_in[i].start ||
			    rove->src_in[i].end != src_in[i].end){
			 match = 0;
			 break;
		    }
		    if(rove->dst_out[i].start != dst_out[i].start ||
		       rove->dst_out[i].end != dst_out[i].end){
			 match = 0;
			 break;
		    }
		    if(rove->dst_in[i].start != dst_in[i].start ||
		       rove->dst_in[i].end != dst_in[i].end){
			 match = 0;
			 break;
		    }
		    if(rove->udp_in[i].start != udp_in[i].start ||
		       rove->udp_in[i].end != udp_in[i].end){
			 match = 0;
			 break;
		    }
		    if(rove->icmp_in[i].start != icmp_in[i].start ||
		       rove->icmp_in[i].end != icmp_in[i].end){
			 match = 0;
			 break;
		    }
	       }
	       if(match){
		    match = rove->id;
		    break;
	       }
	  }
     if(!rove){
	  struct classtable *new;
	  new = (struct classtable *)malloc(sizeof(struct classtable));
	  if(!new){
	       fprintf(stderr, "%s, line %d: malloc failed\n",
		       __FILE__, __LINE__);
	       exit(1);
	  }
	  if(nextid == CLASS_TABLE_SIZE){
	       fprintf(stderr, "Class table overflow\n");
	       exit(1);
	  }
	  new->id = nextid++;
	  new->hash = hash;
	  memcpy(new->src_in, src_in, sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(new->dst_in, dst_in, sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(new->dst_out, dst_out, sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(new->udp_in, udp_in, sizeof(struct classentry)*CLASS_SIZE);
	  memcpy(new->icmp_in, icmp_in, sizeof(struct classentry)*CLASS_SIZE);
	  new->next = classlist;
	  classlist = new;
	  match = new->id;
     }
     return match;
}

static int
compare_entry(struct classentry *x, struct classentry *y)
{
     if(x->start < y->start)
	  return -1;
     else
	  return 1;
}

#if 0
static void
zeroempty(struct classentry buf[CLASS_SIZE])
{
     int i;
     for(i=CLASS_SIZE-1;i>=0;i--)
	  if(buf[i].start == 65535 && buf[i].end == 65535)
	       buf[i].start = buf[i].end = 0;
	  else
	       break;
}
#endif

static int
coalesce(struct classentry buf[], int size)
{
     int ndx, i;
     size--;

     for(ndx=0;;){
	  if(ndx == size)
	       break;
	  if(buf[ndx].end+1 == buf[ndx+1].start){
	       buf[ndx].end = buf[ndx+1].end;
	       for(i=ndx+1;i<size;i++)
		    buf[i] = buf[i+1];
	       size--;
	  }
	  else
	       ndx++;
     }
     return ndx+1;
}

static void 
filltable(struct classentry buf[CLASS_SIZE], struct port_range *list, int shift)
{
     struct port_range *rove;
     struct classentry *build;
     int buildsize;
     int ndx;

     buildsize = 16;
     build = (struct classentry *)malloc(sizeof(struct classentry)*buildsize);
     if(!build){
	  fprintf(stderr, "%s, line %d: malloc failed\n", __FILE__, __LINE__);
	  exit(1);
     }
     for(ndx=0,rove=list;  rove;  rove=rove->pr_next){
	  if(rove->pr_start != 65535 || rove->pr_end != 65535){
	       if(ndx == buildsize){
		    buildsize *= 2;
		    build = (struct classentry *)
			 realloc(build,sizeof(struct classentry)*buildsize);
		    if(!build){
			 fprintf(stderr, "%s, line %d: realloc failed\n",
				 __FILE__, __LINE__);
			 exit(1);
		    }
			 
	       }
	       if (shift) {
		    build[ndx].start = rove->pr_start + 1;
		    build[ndx].end = rove->pr_end + 1;
	       } else {
		    build[ndx].start = rove->pr_start;
		    build[ndx].end = rove->pr_end;
	       }
	       ndx++;
	  }
     }

     memset(buf, 0, CLASS_SIZE*sizeof(struct classentry));
     if(ndx){
	  qsort(build, ndx, sizeof(struct classentry), (void *) compare_entry);
	  ndx = coalesce(build, ndx);

	  /*
	   * This is CLASS_SIZE minus 1 because the last entry in the class
	   * table is reserved and must always be 0.
	   */
	  if(ndx >= CLASS_SIZE-1) {
	       fprintf(stderr, "\"%s\", line %d: Class entry too large " \
	       		"(%d entries).\n", getfilename(), getlinenum(), ndx);
	       exit(1);
	  }
	  memcpy(buf, build, ndx*sizeof(struct classentry));
     }

     if(ndx < minclasslen)
	  minclasslen = ndx;
     if(ndx > maxclasslen)
	  maxclasslen = ndx;
     totclasslen += ndx;
     totclasses++;
}

void
gen_class(struct classentry srcbuf[CLASS_SIZE],
	  struct classentry indstbuf[CLASS_SIZE],
	  struct classentry outdstbuf[CLASS_SIZE],
	  struct classentry udp_in[CLASS_SIZE],
	  struct classentry icmp_in[CLASS_SIZE])
{
     struct filt_protocols *fp_rove;

     /* We only care about these three.. */
     remove_deny(FP_IN,FP_SRC);
     remove_deny(FP_IN,FP_DST);
     remove_deny(FP_OUT,FP_DST);

     for(fp_rove = fp_head;fp_rove;fp_rove=fp_rove->fp_next)
	  switch(fp_rove->fp_id){
	  case IPPROTO_TCP:
	       filltable(srcbuf, fp_rove->fp_pr[FP_ACC][FP_IN][FP_SRC], 0);
	       filltable(indstbuf, fp_rove->fp_pr[FP_ACC][FP_IN][FP_DST], 0);
	       filltable(outdstbuf, fp_rove->fp_pr[FP_ACC][FP_OUT][FP_DST], 0);
	       break;
	  case IPPROTO_UDP:
	       filltable(udp_in, fp_rove->fp_pr[FP_ACC][FP_IN][FP_DST], 0);
	       break;
	  case IPPROTO_ICMP:
	       filltable(icmp_in, fp_rove->fp_pr[FP_ACC][FP_IN][FP_DST], 1);
	       break;
	  default:
	       break;
	  }
}

int
make_class(void)
{
     struct classentry srcbuf[CLASS_SIZE];
     struct classentry indstbuf[CLASS_SIZE];
     struct classentry outdstbuf[CLASS_SIZE];
     struct classentry udp_in[CLASS_SIZE];
     struct classentry icmp_in[CLASS_SIZE];
     int i;

     for(i=0;i<CLASS_SIZE;i++){
	  srcbuf[i].start = srcbuf[i].end = 0;
	  indstbuf[i].start = indstbuf[i].end = 0;
	  outdstbuf[i].start = outdstbuf[i].end = 0;
	  udp_in[i].start = udp_in[i].end = 0;
	  icmp_in[i].start = icmp_in[i].end = 0;
     }

     gen_class(srcbuf, indstbuf, outdstbuf, udp_in, icmp_in);

     return locate_class(srcbuf, indstbuf, outdstbuf, udp_in, icmp_in);
}
