/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <errno.h>
#include "chario.h"
#include "services.h"
#include "hosts.h"
#include "groups.h"
#include "classes.h"
#include "version.h"

#define DEFAULT_OUTPUT_FILE "db_filters"

int parse_error = 0;
extern int yyparse(void);

void
showcopyright(void)
{
     fprintf(stdout, \
	"Drawbridge Filter Compiler %s,\n" \
	"Copyright (C) 1993,1994,1995,1998 Texas A&M University\n" \
	"Drawbridge and the Filter Compiler comes with "\
	"ABSOLUTELY NO WARRANTY.\n", VERSION);
}

static void
showusage(char *toolname)
{
     fprintf(stderr, "Usage: %s [-v] input-file [output-file]\n", toolname);
}

extern int optind;
extern char *optarg;

int
main(int argc, char **argv)
{
     char *out_file;
     int status;
     int c;

     while ((c=getopt(argc, argv, "vh")) != -1)
	  switch(c){
	  case 'v':
	       showcopyright();
	       exit(0);
	  case 'h':
	  default:
               showusage(argv[0]);
	       exit(1);
	  }

     if (!argv[optind]) {
	  showusage(argv[0]);
	  exit(1);
     }

     if (addfile(argv[optind]) != NOERR) {
	  perror(argv[optind]);
	  exit(1);
     }

     if (argv[optind+1])
	  out_file = argv[optind+1];
     else
	  out_file = DEFAULT_OUTPUT_FILE;


     init_services();
     init_groups();
     init_hosts();

     yyparse();

     if(!parse_error){
	  writetables(out_file);
	  status = 0;
     }
     else
	  status = 1;

     exit(status);

     return status;
}

void
yyerror(void)
{
     parse_error = 1;
}
