/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

#ifndef __HOSTS_H__
#define __HOSTS_H__

#include "classes.h"

#ifndef IN_CLASSA_NET
#define IN_CLASSA_NET	0xff000000
#endif
#ifndef IN_CLASSB_NET
#define IN_CLASSB_NET	0xffff0000
#endif
#ifndef IN_CLASSC_NET
#define IN_CLASSC_NET	0xffffff00
#endif
#ifndef IN_CLASSD_NET
#define IN_CLASSD_NET	0xf0000000
#endif

struct hostrange {
	unsigned long start, end;
};

struct hosttable {
     struct hosttable *next;
     int size;
     unsigned int network;
     unsigned char *table;
};

struct accept {
     unsigned int ipaddr;
     unsigned int netmask;
     unsigned int flag;
};

struct reject {
     unsigned int ipaddr;
     unsigned int netmask;
     unsigned int flag;
};

struct override {
     unsigned int ipaddr;
     unsigned int netmask;
     struct classentry ports[CLASS_SIZE];
};

typedef enum { NORMAL, INVERT } norminv;

extern void init_hosts(void);
extern unsigned int getnetmask(unsigned int);
extern void writetables(char *);
extern void do_host(unsigned int);
extern void do_network(struct hostrange, unsigned int);
extern void add_accept(unsigned int, unsigned int, norminv);
extern void add_reject(unsigned int, unsigned int, norminv);
extern void add_override(unsigned int, unsigned int);

#endif
