/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

#include <sys/types.h>
#include <stdio.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#ifdef __FreeBSD__
#include <stdlib.h>
#else
#include <malloc.h>
#endif
#include "macros.h"
#include "chario.h"
#include "services.h"

struct filt_protocols *fp_head;
extern int parse_error;

void
init_services(void)
{
     fp_head = (struct filt_protocols *)0;
}

void
remove_deny(inout in_or_out, srcdst src_or_dst)
{
     struct filt_protocols *fp_rove;
     struct port_range *pr_accept, *pr_invalid;
     struct service s_new;

     for(fp_rove = fp_head;fp_rove;fp_rove = fp_rove->fp_next){
	  pr_invalid = fp_rove->fp_pr[FP_REJ][in_or_out][src_or_dst];
	  for(;pr_invalid;pr_invalid = pr_invalid->pr_next){
	       pr_accept = fp_rove->fp_pr[FP_ACC][in_or_out][src_or_dst];
	       for(;pr_accept;pr_accept = pr_accept->pr_next){
		    if(pr_accept->pr_start == 65535 &&
		       pr_accept->pr_end == 65535)
			 continue;
		    else if(pr_invalid->pr_start <= pr_accept->pr_start &&
			    pr_invalid->pr_end >= pr_accept->pr_end){
			 pr_accept->pr_start = pr_accept->pr_end = 65535;
		    }
		    else if(pr_invalid->pr_start == pr_accept->pr_start &&
			    pr_invalid->pr_end <= pr_accept->pr_end){
			 pr_accept->pr_start = pr_invalid->pr_end+1;
		    }
		    else if(pr_invalid->pr_start > pr_accept->pr_start &&
			    pr_invalid->pr_start <= pr_accept->pr_end){
			 if(pr_invalid->pr_end < pr_accept->pr_end){
			      s_new.start = pr_invalid->pr_end+1;
			      s_new.end = pr_accept->pr_end;
			      s_new.protocol = fp_rove->fp_id;
			      add_service(s_new,in_or_out,src_or_dst,FP_ACC);
			 }
			 pr_accept->pr_end = pr_invalid->pr_start-1;
		    }
		    else if(pr_invalid->pr_end >= pr_accept->pr_start &&
			    pr_invalid->pr_end <= pr_accept->pr_end){
			 if(pr_invalid->pr_start > pr_accept->pr_start){
			      s_new.start = pr_accept->pr_start;
			      s_new.end = pr_invalid->pr_start-1;
			      s_new.protocol = fp_rove->fp_id;
			      add_service(s_new,in_or_out,src_or_dst,FP_ACC);
			 }
			 pr_accept->pr_start = pr_invalid->pr_end+1;
		    }
	       }
	  }
     }
}

void
destroy_services(struct port_range *pl)
{
     struct port_range *rove, *curr;

     for(rove=pl;rove;){
	  curr = rove;
	  rove = rove->pr_next;
	  free(curr);
     }
}

void
destroy_all_services(void)
{
     struct filt_protocols *fp_rove;
     accrej ar;
     inout io;
     srcdst sd;

     for(fp_rove = fp_head;fp_rove;fp_rove = fp_rove->fp_next){
	  FORBOTH(ar, FP_ACC, FP_REJ)
	       FORBOTH(io, FP_IN, FP_OUT)
		    FORBOTH(sd, FP_SRC, FP_DST){
			 destroy_services(fp_rove->fp_pr[ar][io][sd]);
			 fp_rove->fp_pr[ar][io][sd] = (struct port_range *)0;
		    }
     }
}

void
add_service(struct service srv, inout in_or_out, srcdst src_or_dst, accrej acc_or_rej)
{
     struct filt_protocols *fp_rove;
     struct port_range *pr_new;

     fflush(stdout);
     pr_new = NEW(struct port_range);
     if(!pr_new){
	  fprintf(stderr, "%s, line %d: malloc failed\n", __FILE__, __LINE__);
	  exit(1);
     }
     pr_new->pr_start = srv.start;
     pr_new->pr_end = srv.end;

     for(fp_rove = fp_head;fp_rove;fp_rove = fp_rove->fp_next)
	  if(fp_rove->fp_id == srv.protocol)
	       break;
     if(!fp_rove){
	  inout io;
	  accrej ar;
	  srcdst sd;

	  fp_rove = NEW(struct filt_protocols);
	  fp_rove->fp_next = fp_head;
	  fp_head = fp_rove;
	  fp_rove->fp_id = srv.protocol;

	  FORBOTH(ar, FP_ACC, FP_REJ)
	       FORBOTH(io, FP_IN, FP_OUT)
		    FORBOTH(sd, FP_SRC, FP_DST)
			 fp_rove->fp_pr[ar][io][sd] = (struct port_range *)0;
     }

     pr_new->pr_next = fp_rove->fp_pr[acc_or_rej][in_or_out][src_or_dst];
     fp_rove->fp_pr[acc_or_rej][in_or_out][src_or_dst] = pr_new;
}

void
push_service(struct service srv, inout in_or_out, srcdst src_or_dst, accrej acc_or_rej)
{
     struct port_range *pr_rove;
     struct filt_protocols *fp_rove;
     int start, end;

     start = srv.start;
     end = srv.end;

     if(srv.protocol == IPPROTO_ICMP) {
          if(start < 0 || start > 255){
          	  fprintf(stderr, "\"%s\", line %d: invalid icmp type %d\n",
		       getfilename(), getlinenum(), start);
	       parse_error = 1;
          }
          if(end < 0 || end > 255){
	       fprintf(stderr, "\"%s\", line %d: invalid icmp type %d\n",
		       getfilename(), getlinenum(), end);
	       parse_error = 1;
          }
     } else {
          if(start == 0 || start > 65535){
          	  fprintf(stderr, "\"%s\", line %d: invalid port number %d\n",
		       getfilename(), getlinenum(), start);
	       parse_error = 1;
          }
          if(end == 0 || end > 65535){
	       fprintf(stderr, "\"%s\", line %d: invalid port number %d\n",
		       getfilename(), getlinenum(), end);
	       parse_error = 1;
          }
     }

     if(end < start){
	  fprintf(stderr, "\"%s\", line %d: start port > end port.\n",
		  getfilename(), getlinenum());
	  parse_error = 1;
     }
     
     for(fp_rove = fp_head;fp_rove;fp_rove = fp_rove->fp_next)
	  if(fp_rove->fp_id == srv.protocol)
	       break;

     if(fp_rove){
	  pr_rove = fp_rove->fp_pr[acc_or_rej][in_or_out][src_or_dst];
	  for(;pr_rove;pr_rove=pr_rove->pr_next){
	       if(start == pr_rove->pr_start && end == pr_rove->pr_end){
		    break;
	       }
	       else if(end >= pr_rove->pr_start && end <= pr_rove->pr_end){
		    if(start < pr_rove->pr_start)
			 pr_rove->pr_start = start;
		    break;
	       }
	       else if(start >= pr_rove->pr_start && start <= pr_rove->pr_end){
		    if(end > pr_rove->pr_end)
			 pr_rove->pr_end = end;
		    break;
	       }
	       else if(start < pr_rove->pr_start && end > pr_rove->pr_end){
		    pr_rove->pr_start = start;
		    pr_rove->pr_end = end;
		    break;
	       }
	  }
	  if(!pr_rove)
	       add_service(srv, in_or_out, src_or_dst, acc_or_rej);
     }
     else {
	  add_service(srv, in_or_out, src_or_dst, acc_or_rej);
     }
}

void
push2_service(struct service srv, int dirset, srcdst src_or_dst, accrej acc_or_rej)
{
     /* dirset can indicate in (1), out (2) or in & out (3) */
     if(dirset & (FP_IN+1))
	  push_service(srv, FP_IN, src_or_dst, acc_or_rej);
     if(dirset & (FP_OUT+1))
	  push_service(srv, FP_OUT, src_or_dst, acc_or_rej);
}
