/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>

#include "drawbrdg.h"
#include "dbmgr.h"
#include "tokens.h"
#include "misc.h"

#define __CONTROL__
#include "text.h"

/*------------------------------------------------------------*/

void
usageInit(int verbose)
{
	fprintf(theOutput, "%s%s",
		(verbose) ? initText[0] : initText[0]+1,
		(verbose) ? initText[1] : "");
}

void
usageStart(int verbose)
{
	fprintf(theOutput, "%s%s",
		(verbose) ? startText[0] : startText[0]+1,
		(verbose) ? startText[1] : "");
}

void
usageStop(int verbose)
{
	fprintf(theOutput, "%s%s",
		(verbose) ? stopText[0] : stopText[0]+1,
		(verbose) ? stopText[1] : "");
}

/*------------------------------------------------------------*/

void
handleInit()
{
	char *inside, *outside, *mode;
	initReq r;

	inside = strtok(NULL, DELIMITERS);
	outside = strtok(NULL, DELIMITERS);
	mode = strtok(NULL, DELIMITERS);

	/*
	 * Make sure we have all the parameters
	 */
	if (!inside || !outside || !mode) {
		usageInit(TERSE);
		return;
	}

	/*
	 * Make sure the listen interface is valid
	 */
	if (strcasecmp(mode, "inside") == 0)
		r.listenMode = DB_INSIDE_IF;
	else if (strcasecmp(mode, "outside") == 0)
		r.listenMode = DB_OUTSIDE_IF;
	else if (strcasecmp(mode, "both") == 0)
		r.listenMode = DB_INSIDE_IF | DB_OUTSIDE_IF;
	else if (strcasecmp(mode, "none") == 0)
		r.listenMode = 0;
	else {
		fprintf(stderr, "   The listen interface must be " \
			"'inside', 'outside', 'both', or 'none'\n");
		return;
	}

	/*
	 * Setupt the request structure making sure not to overrun buffers.
	 */
	strncpy(r.inName, inside, MAX_DEV_NAMELEN-2);
	r.inName[MAX_DEV_NAMELEN-1] = 0;
	strncpy(r.outName, outside, MAX_DEV_NAMELEN-2);
	r.outName[MAX_DEV_NAMELEN-1] = 0;

	/*
	 * Send the initialize request
	 */
	if (ioctl(theSocket, DIOCINIT, &r))
		dfm_perror("DIOCINIT");
	else
		printf("   Drawbridge initialized\n");
}

/*------------------------------------------------------------*/

void
handleStart()
{
	/*
	 * Send the start request
	 */
	if (ioctl(theSocket, DIOCSTART))
		dfm_perror("DIOCSTART");
	else 
		printf("   Drawbridge running\n");
}

/*------------------------------------------------------------*/

void
handleStop()
{
	/*
	 * Send the stop request
	 */
	if (ioctl(theSocket, DIOCSTOP))
		dfm_perror("DIOCSTOP");
	else
		printf("   Drawbridge stoped\n");
}

/*------------------------------------------------------------*/
