/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>

#include "drawbrdg.h"
#include "dbmgr.h"
#include "tokens.h"
#include "misc.h"

static char prompt[] = "dbmgr> ";
FILE *debug = stderr;
FILE *theOutput = stdout;
FILE *theInput = stdin;
FILE *theErrors = stderr;
int theSocket;
char *facilities[] = {
	"kern", "user", "mail", "daemon", "auth", "syslog",
	"lpr", "news", "uucp", "cron", "authpriv", "ftp",
	"reserved0", "reserved1", "reserved2", "reserved3",
	"local0", "local1", "local2", "local3", "local4",
	"local5", "local6", "local7", ""
};

static unsigned char readBuffer[256];

/*------------------------------------------------------------*/

void
showcopyright(void)
{
	fprintf(theOutput, \
		"Drawbridge Manager %s\n" \
		"Copyright (C) 1993,1995,1996,1998 Texas A&M University\n" \
		"Drawbridge and the Drawbridge Manager comes with " \
		"ABSOLUTELY NO WARRANTY.\n", VERSION);
}

/*------------------------------------------------------------*/

void
showusage(char *toolname)
{
	fprintf(theOutput, \
		"Usage: %s [ <-v | -h> | <command> ]\n", toolname);
}

/*------------------------------------------------------------*/

void
handleInput(char *cmdline)
{
	int result;
	char *currTok;

	if (*cmdline)
		strcpy(readBuffer, cmdline);
	else {
		fprintf(theOutput, prompt);
		fgets(readBuffer, sizeof(readBuffer), theInput);
	}

	while (!feof(theInput)) {

		currTok = strtok(readBuffer, " \t\n");
		result = findtoken(currTok);

		switch (result) {
			case T_HELP:
				handleHelp();
				break;
			case T_INIT:
				handleInit();
				break;
			case T_START:
				handleStart();
				break;
			case T_STOP:
				handleStop();
				break;
			case T_SET:
				handleSet();
				break;
			case T_LOAD:
				handleLoad();
				break;
			case T_CLEAR:
				handleClear();
				break;
			case T_SHOW:
				handleShow();
				break;
			case T_MONITOR:
				handleMonitor();
				break;
			case T_SHELL1:
				currTok = strtok(NULL, " ");
			case T_SHELL2: {
				int i,j;
				char command[256];

				strcpy(command, "/bin/sh -c \'");
				/*
	 			 * Copy the rest of the command line without
				 * overrunning 'command' buffer.
	 			 */
				for (i=strlen(command); i<256 && currTok; ) {
					int len = strlen(currTok);
					for (j=0; j<len && i<256; j++)
						command[i++] = currTok[j];
					if (i<256)
						command[i++] = ' ';
					currTok = strtok(NULL, " ");
				}
				command[ (i<256) ? i++ : 255 ] = '\'';
				command[ (i<256) ? i : 255 ] = 0;

				if (system(command) == 127)
					fprintf(theErrors,
						"   Shell escape failed\n");
				break;
			}
			case T_EXIT:
				return;
				break;
			case T_COMMENT:
				break;
			default:
				fprintf(theErrors, "   Unknown command\n");
		}

		if (*cmdline)
			break;
		else {
			fprintf(theOutput, prompt);
			fgets(readBuffer, sizeof(readBuffer), theInput);
		}
	}
}

/*------------------------------------------------------------*/

void
main(int argc, char **argv)
{
	int i,j,k;
	char cmdline[256];
	char c;

	while ((c=getopt(argc, argv, "vh")) != -1) {
		switch(c) {
		case 'v':
			showcopyright();
			exit(0);
		case 'h':
			handleInput("help");
			exit(0);
		default:
			showusage(argv[0]);
			exit(1);
		}
	}

	if ((theSocket = open("/dev/drawbridge", O_RDWR)) < 0) {
		if ((theSocket = open("/dev/drawbridge", O_RDONLY)) < 0) {
			dfm_perror("open /dev/drawbridge");
			exit(1);
		}
	}

	if (checkversion()) {
		fprintf(theErrors, "\n   This version of dbmgr does not match "
			"the version of\n   Drawbridge running within the "
			"kernel!  Unable to continue.\n\n");
		exit(1);
	}

	/*
	 * Copy command line args to the cmdline buffer without overrunning it.
	 */
	for (i=1,j=0,*cmdline=0; argc>1 && j<256; i++,argc--) {
		int len = strlen(argv[i]);
		for (k=0; k<len && j<256; k++)
			cmdline[j++] = argv[i][k];
		if (j<256)
			cmdline[j++] = ' ';
	}
	cmdline[ (j<256) ? j : 255 ] = 0;

	setvbuf(theOutput, NULL, _IOLBF, 0);
	setvbuf(theInput, NULL, _IOLBF, 0);

	if (*cmdline == 0)
		showcopyright();

	handleInput(cmdline);

	close(theSocket);
}

/*------------------------------------------------------------*/
