/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <errno.h>

#include "drawbrdg.h"
#include "misc.h"
#include "dbmgr.h"

#define __MISC__
#include "text.h"

/*------------------------------------------------------------*/

void
dfm_perror(char *func)
{
	char *msg;

	if ((errno >= 100) && (errno < MAX_ERROR_NUM))
		msg = errormsg[errno - 100];
	else
		msg = strerror(errno);

	if (func)
		fprintf(theErrors, "   %s: %s\n", func, msg);
	else
		fprintf(theErrors, "   %s\n", msg);
}

/*------------------------------------------------------------*/

int
checkversion()
{
	versionReq ver;

	if (ioctl(theSocket, DIOCGVER, &ver)) {
		dfm_perror("DIOCGVER");
		fprintf(theErrors, "   Could not read the version number "
			"of Drawbridge.\n");
		exit(1);
	}
	if (strncmp(ver.version, VERSION, 32) == 0)
		return NOERROR;
	return ERROR;
}

/*------------------------------------------------------------*/

int
classTableReq(char req,  char table, u_short row,
		accessListTableReq *class)
{
	class->class = table;
	class->row   = row;
	if (req == READ) {
		if (ioctl(theSocket, DIOCGCLASS, class)) {
			dfm_perror("DIOCGCLASS");
			return ERROR;
		}
	} else if (req == WRITE) {
		if (ioctl(theSocket, DIOCSCLASS, class)) {
			dfm_perror("DIOCSCLASS");
			return ERROR;
		}
	} else 
		return ERROR;

	return NOERROR;
}

/*------------------------------------------------------------*/

int
strIsNumeric(char *str)
{
	char *c;

	for (c = str; *c; c++) {
		if ((*c < '0') || (*c > '9'))
			return FALSE;
	}

	return TRUE;
}

/*------------------------------------------------------------*/

char
*fmt_small(unsigned long val, int flag)
{
	static char str1[20];
	static char str2[30];
	register char *p;
	register int i=sizeof(str2);

	if (flag && (val > 99999)) val = 99999;

	sprintf(str1, "%15lu", val);
	str2[--i] = 0;
	p = str1 + strlen(str1) - 1;
	while ((*p != ' ') && (p != str1)) {
	   str2[--i] = *p--;
	   str2[--i] = *p--;
	   str2[--i] = *p--;
	   str2[--i] = ',';
	}
	while ((str2[i] == ' ') || (str2[i] == ',')) i++;
	return (str2+i);
}

/*------------------------------------------------------------*/

char
*fmt_big(u_int64_t stat)
{
	static char str1[35];
	static char str2[45];
	register char *p;
	register int i=sizeof(str2);

	sprintf(str1, "%30qu", stat);
	str2[--i] = 0;
	p = str1 + strlen(str1) - 1;
	while ((*p != ' ') && (p != str1)) {
	   str2[--i] = *p--;
	   str2[--i] = *p--;
	   str2[--i] = *p--;
	   str2[--i] = ',';
	}
	while ((str2[i] == ' ') || (str2[i] == ',')) i++;
	return (str2+i);
}

/*------------------------------------------------------------*/

char
*fmt_abbrv(unsigned long val)
{
        static char str1[20];
        static char str2[30];
        register char *p;
        register int i;

        if (val < 1000UL) {
                sprintf(str2, "%lu", val);

        } else if (val < 1000000UL) {
                sprintf(str1, "%lu", val / 100 );
                for (p=str2,i=0; str1[i+1]; i++)
                        *p++ = str1[i];
                *p++ = '.'; *p++ = str1[i];
                *p++ = 'K'; *p++ = 0;

        } else if (val < 1000000000UL) {
                sprintf(str1, "%lu", val / 100000 );
                for (p=str2,i=0; str1[i+1]; i++)
                        *p++ = str1[i];
                *p++ = '.'; *p++ = str1[i];
                *p++ = 'M'; *p++ = 0;

        } else  {
                sprintf(str1, "%lu", val / 100000000UL );
                for (p=str2,i=0; str1[i+1]; i++)
                        *p++ = str1[i];
                *p++ = '.'; *p++ = str1[i];
                *p++ = 'G'; *p++ = 0;
        }
        return (str2);
}

/*------------------------------------------------------------*/
