/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <ctype.h>

#include "drawbrdg.h"
#include "dbmgr.h"
#include "tokens.h"
#include "misc.h"

#define __SET__
#include "text.h"

/*------------------------------------------------------------*/

static void
usageSetLog()
{
	fprintf(theOutput, setText[0]+1);
}

static void
usageSetFlag()
{
	fprintf(theOutput, setText[1]);
}

void
usageSet(int verbose)
{
	fprintf(theOutput, "%s%s%s",
		(verbose) ? setText[0] : setText[0]+1, setText[1],
		(verbose) ? setText[2] : "");
}

void
usageSetDetailed(int token)
{
	switch (token) {

	case T_LOGFACILITY:
		fprintf(theOutput, setText[3]);
		break;
	case T_LOGMASK:
		fprintf(theOutput, setText[4]);
		break;
	case T_MULTICAST:
		fprintf(theOutput, setText[5]);
		break;
	case T_NONIP:
		fprintf(theOutput, setText[6]);
		break;
	case T_OTHERIP:
		fprintf(theOutput, setText[7]);
		break;
	case T_SUSPECTOFF:
		fprintf(theOutput, setText[8]);
		break;
	case T_FRAGICMP:
		fprintf(theOutput, setText[9]);
		break;
	case T_ATTACKICMP:
		fprintf(theOutput, setText[10]);
		break;
	default:
		usageSet(VERBOSE);
		break;
	}
}

/*------------------------------------------------------------*/

void
handleSet()
{
	int i;
	int result;
	char *currTok;
	flagsReq flags;
	logFacilityReq freq;
	logMaskReq mreq;

	currTok = strtok(NULL, DELIMITERS);
	result = findtoken(currTok);

	currTok = strtok(NULL, DELIMITERS);
	if (!currTok) {
		usageSet(TERSE);
		return;
	}

	switch (result) {

	case T_LOGFACILITY:
		for (i=0; facilities[i][0]; i++)
			if (strcasecmp(currTok, facilities[i]) == 0) break;
		if (facilities[i][0] == NULL) {
			fprintf(stderr, "   Invalid log facility\n");
			break;
		}
		freq.facility = i;
		if (ioctl(theSocket, DIOCSLOGF, &freq))
			dfm_perror("DIOCSLOGF");
		break;

	case T_LOGMASK:
		if ((currTok[0] == '0') && (tolower(currTok[1]) == 'x')) {
			if (sscanf(currTok, "%lx", (u_long *)&mreq.mask) != 1) {
				fprintf(stderr, "   Invalid mask\n");
				break;
			}
		} else {
			if (sscanf(currTok, "%ld", (u_long *)&mreq.mask) != 1) {
				fprintf(stderr, "   Invalid mask\n");
				break;
			}
		}
		if (ioctl(theSocket, DIOCSLOGM, &mreq))
			dfm_perror("DIOCSLOGM");
		break;

	case T_MULTICAST:
	case T_NONIP:
	case T_OTHERIP:
	case T_SUSPECTOFF:
	case T_FRAGICMP:
	case T_ATTACKICMP:

		i = findtoken(currTok);
		if (i == T_FORWARD)
			i = 0;
		else if (i == T_DISCARD)
			i = 1;
		else {
			usageSetFlag();
			break;
		}

		if (ioctl(theSocket, DIOCGFLAGS, &flags)) {
			dfm_perror("DIOCSFLAGS");
			break;
		}

		if (result == T_MULTICAST)
			flags.discardMulticast = i;
		else if (result == T_NONIP)
			flags.discardNonIp = i;
		else if (result == T_OTHERIP)
			flags.discardOtherIp = i;
		else if (result == T_SUSPECTOFF)
			flags.discardSuspectOffset = i;
		else if (result == T_FRAGICMP)
			flags.discardFragmentedICMP = i;
		else if (result == T_ATTACKICMP)
			flags.discardAttackICMP = i;

		if (ioctl(theSocket, DIOCSFLAGS, &flags))
			dfm_perror("DIOCSFLAGS");
		break;

	default:
		usageSet(TERSE);
	}
}

/*------------------------------------------------------------*/
