/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

/*------------------------------------------------------------*/

#ifdef __CONTROL__

static char *initText[] = {
"\n"
"   INIT <inside dev> <outside dev> <management interface>\n",
/*--------*/
"\n"
"   The 'init' command has three parameters, the device name of the inside\n"
"   interface, the device name of the outside interface, and the management\n"
"   interface.  The management interface may be 'inside', 'outside', 'both',\n"
"   or 'none'.\n"
"\n"
};

static char *startText[] = {
"\n"
"   START\n",
/*--------*/
"\n"
"   The 'start' command will enable the drawbridge filter engine within the\n"
"   FreeBSD kernel.  No packets will pass between the two interfaces until\n"
"   drawbridge has been started.\n"
"\n"
};

static char *stopText[] = {
"\n"
"   STOP\n",
/*--------*/
"\n"
"   The 'stop' command will disable the drawbridge filter engine within the\n"
"   FreeBSD kernel.  No packets will pass between the two interfaces while\n"
"   drawbridge is stopped.\n"
"\n"
};

#endif

/*------------------------------------------------------------*/

#ifdef __SET__

static char *setText[] = {
"\n"
"   SET (LogFacility | LogMask) <val>\n",
/*--------*/
"   SET (MULticast | NonIP | OtherIP | SuspectOffset |\n"
"        FragmentedICMP | AttackICMP) (FORward | DIScard)\n",
/*--------*/
"\n"
"   The 'set' command is used to set global variables or flags.\n"
"   Type 'HELP SET <variable | flag>' for more information.\n"
"\n",
/*--------*/
"\n"
"   SET LogFacility <val>\n\n"
"   The 'LogFacility' variable controls which messages are generated by\n"
"   drawbridge to be passed to the unix syslog daemon for processing.\n"
"   The log facility that drawbridge uses may be set to any valid syslog\n"
"   facility.  Some examples are: 'user', 'daemon', 'local0'.\n"
"\n",
/*--------*/
"\n"
"   SET LogMask <val>\n\n"
"   The 'LogMask' variable controls which messages will be generated by the\n"
"   drawbridge filter engine.  The value of the mask is a hexadecimal or \n"
"   decimal number such as 0x123ABC or 1194684.  The default log mask is 0\n"
"   which disables all filter messages.  Each filter message may be enabled\n"
"   or disabled by setting or clearing the appropriate bit in the log mask.\n\n"
"   The following table of syslog messages and values may be used to\n"
"   generate a mask.  Simply add up the decimal values (or bitwise OR the\n"
"   hex values) for the messages that you wish to receive and set LogMask\n"
"   to that value.\n\n"
"   Message                                        Hex Value  (Decimal)\n"
"   --------------------------------------------------------------------\n"
"   unknown event                                  0x00000001 (       1)\n"
"   cold start                                     0x00000002 (       2)\n"
"   incoming class D ...                           0x00000004 (       4)\n"
"   outgoing class D ...                           0x00000008 (       8)\n"
"   incoming port ...                              0x00000010 (      16)\n"
"   outgoing port ...                              0x00000020 (      32)\n"
"   incoming type ...                              0x00000040 (      64)\n"
"   outgoing type ...                              0x00000080 (     128)\n"
"   incoming via reject table ...                  0x00000100 (     256)\n"
"   outgoing via accept table ...                  0x00000200 (     512)\n"
"   outgoing via override table ...                0x00000400 (    1024)\n"
"   incoming header too short ...                  0x00000800 (    2048)\n"
"   outgoing header too short ...                  0x00001000 (    4096)\n"
"   incoming D-O-S attack ...                      0x00002000 (    8192)\n"
"   outgoing D-O-S attack ...                      0x00004000 (   16384)\n"
"   incoming IP ...                                0x00008000 (   32768)\n"
"   outgoing IP ...                                0x00010000 (   65536)\n"
"   incoming fragment with IP offset == 1 ...      0x00020000 (  131072)\n"
"   outgoing fragment with IP offset == 1 ...      0x00040000 (  262144)\n"
"   incoming fragment ...                          0x00080000 (  524288)\n"
"   outgoing fragment  ...                         0x00100000 ( 1048576)\n"
"   incoming MAC layer protocol                    0x00200000 ( 2097152)\n"
"   outgoing MAC layer protocol                    0x00400000 ( 4194304)\n"
"\n",
/*--------*/
"\n"
"   SET MULticast (FORward | DIScard)\n\n"
"   The 'Multicast' flag controls whether IP multicast packets are forwarded\n"
"   or discarded.\n"
"\n",
/*--------*/
"\n"
"   SET NonIP (FORward | DIScard)\n\n"
"   The 'NonIP' flag controls whether protocol layer traffic other than IP,\n"
"   ARP, or RARP is forwarded or discarded.\n"
"\n",
/*--------*/
"\n"
"   SET OtherIP (FORward | DIScard)\n\n"
"   The 'OtherIP' flag controls whether IP layer traffic other than TCP, UDP,\n"
"   or ICMP is forwarded or discarded.\n"
"\n",
/*--------*/
"\n"
"   SET SuspectOffset (FORward | DIScard)\n\n"
"   The 'SuspectOffset' flag controls whether TCP/IP fragments with an offset\n"
"   of 1 should be forwarded or discarded.  This is mainly used to protect\n"
"   internal machines that may have poorly written IP fragment reassembly\n"
"   routines.  The default setting is 'forward' since discarding these\n"
"   packets could, though unlikely, discard valid traffic.\n"
"\n",
/*--------*/
"\n"
"   SET FragmentedICMP (FORward | DIScard)\n\n"
"   The 'FragmentedICMP' flag controls whether fragmented ICMP packets\n"
"   should be forwarded or discarded.  This is mainly used to block denial\n"
"   of service attacks which use fragmented ICMP echo reply packets.  For\n"
"   example, the \"ping of death\" is a denial of service attack of this\n"
"   type.  The default setting is 'forward' since discarding these packets\n"
"   could, though unlikely, discard valid traffic.\n"
"\n",
/*--------*/
"\n"
"   SET AttackICMP (FORward | DIScard)\n\n"
"   The 'AttackICMP' flag controls whether ICMP packets containing the\n"
"   characteristics of a few known ICMP attacks are forwarded or discarded.\n"
"   The default setting is 'forward' since discarding these packets could,\n"
"   though unlikely, discard valid traffic.\n"
"\n"
};

#endif

/*------------------------------------------------------------*/

#ifdef __LOAD__

static char *loadText[] = {
"\n"
"   Load FILters <filename>\n",
/*--------*/
"\n"
"   The 'load' command is used to load the filters file that is generated\n"
"   by the filter compiler ('db_filters' by default).  The loaded filters\n"
"   will take effect immediately.\n"
"\n"
};

#endif

/*------------------------------------------------------------*/

#ifdef __CLEAR__

static char *clearText[] = {
"\n"
"   CLeaR (FILters | STats | BRidge)\n",
/*--------*/
"\n"
"   The 'clear' command can be used to clear the filter tables, the stats,\n"
"   or the bridge table.  If the filter tables are cleared, drawbridge will\n"
"   fall back to the default filter tables.  The changes take effect\n"
"   immediately.\n"
"\n"
};

#endif

/*------------------------------------------------------------*/

#ifdef __SHOW__

static char *showText[] = {
"\n"
"   SHow (Host <host> | CLass <class | host> | NETworks | ACCept | REJect |\n"
"         OVerride | FLags | STats | LogFacility | LogMask | BRidge)\n",
/*--------*/
"\n"
"  The 'show' command will display the specified filter table information,\n"
"  flags, variables, statistics, or the bridge table.\n"
"\n"
};

#endif

/*------------------------------------------------------------*/

#ifdef __MONITOR__

static char *monitorText[] = {
"\n"
"   MONitor [ INTerval <seconds> ]\n",
/*--------*/
"\n"
"   The 'monitor' command will display a full screen of packet statistics\n"
"   which is updated once per second by default.  The update interval may\n"
"   be specified from 1 to 60 seconds.  The space bar will toggle screens\n"
"   to display a breakdown of the number of filtered packets.  The 'q' key\n"
"   will quit back to the dbmgr prompt.\n"
"\n"
};

#endif

/*------------------------------------------------------------*/

#ifdef __MISC__

static char *errormsg[] = {
	"Parameter out of range",
	"Invalid class specified",
	"Invalid network specified",
	"Table is full",
	"Network Not found",
	"Unable to allocate memory",
	"Invalid operation",
	"Interface is down or not running",
	"Error getting hardware address",
	"Error getting IP address",
	"Invalid interface",
	"Can not use the same interface",
	"Interfaces must be of the same media type",
	"Unsupported media type",
	"Inside interface is down or not running",
	"Outside interface is down or not running",
	"Only one interface can have an IP address assigned",
	"One interface must have an IP address assigned",
	"Invalid management mode specified",
	"Drawbridge has not been initialized",
	"Error - Drawbridge is currently running",
	"Error - Drawbridge is not running",
};

#endif

/*------------------------------------------------------------*/
