/*
 * Copyright (c) 1993,1994,1995,1997,1998
 *      Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Texas A&M University
 *      and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *     Russell Neeper, David K. Hess, Douglas Lee Schales, David R. Safford
 */

#include <string.h>
#include "tokens.h"

struct keywds {
	char *name;
	char *altname;
	int token;
};

static struct keywds keywords[] = {
	{ "ACCept",		"ACC",		T_ACCEPT },
	{ "AttackICMP",		"AICMP",	T_ATTACKICMP },
	{ "BRidge",		"BR",		T_BRIDGE },
	{ "CLass",		"CL",		T_CLASS },
	{ "CLeaR",		"CLR",		T_CLEAR },
	{ "DIScard",		"DIS",		T_DISCARD },
	{ "FILters",		"FIL",		T_FILTERS },
	{ "FLags",		"FL",		T_FLAGS }, 
	{ "FORward",		"FOR",		T_FORWARD },
	{ "FragmentedICMP",	"FICMP",	T_FRAGICMP },
	{ "HELP",		"?",		T_HELP },
	{ "Host",		"H",		T_HOST },  
	{ "INIT",		"INIT",		T_INIT },  
	{ "INTerval",		"INT",		T_INTERVAL },
	{ "Load",		"L",		T_LOAD },
	{ "LogFacility",	"LF",		T_LOGFACILITY },
	{ "LogMask",		"LM",		T_LOGMASK },
	{ "MONitor",		"MON",		T_MONITOR },
	{ "MULticast",		"MUL",		T_MULTICAST },
	{ "NETwork",		"NET",		T_NETWORK },
	{ "NETworks",		"NET",		T_NETWORK },
	{ "NonIP",		"NIP",		T_NONIP },
	{ "OtherIP",		"OIP",		T_OTHERIP },
	{ "OVerride",		"OV",		T_OVERRIDE },
	{ "REJect",		"REJ",		T_REJECT },
	{ "REMove",		"REM",		T_REMOVE },
	{ "SET",		"SET",		T_SET },
	{ "SHow",		"SH",		T_SHOW },
	{ "START",		"START",	T_START },
	{ "STats",		"ST",		T_STATS },
	{ "STOP",		"STOP",		T_STOP },
	{ "SuspectOffset",	"SO",		T_SUSPECTOFF },
	{ "EXit",		"EX",		T_EXIT },
	{ "Quit",		"Q",		T_EXIT },
	{ "!",			"!",		T_SHELL1 },
	{ NULL,			NULL,		0 }
};

int
findtoken(char *token)
{
	int i;

	if (!token || *token == '#')
		return T_COMMENT;

	if (token[0] == '!' && token[1] != 0) {
		token[0] = ' ';
		return T_SHELL2;
	}

	for(i=0; keywords[i].name; i++) {
		if ( (strcasecmp(token, keywords[i].altname) == 0) ||
		     (strcasecmp(token, keywords[i].name) == 0) )
			return keywords[i].token;
	}

	return T_UNKNOWN;
}
