#	$Id: dot.cshrc,v 1.5.2.1 1997/09/27 15:35:53 joerg Exp $
#
# .cshrc - csh resource script, read at beginning 
#	   of execution by each shell
#
# see also csh(1), environ(7).
#

alias h		history 25
alias j		jobs -l
alias la	ls -a
alias lf	ls -FA
alias ll	ls -lA
#
# For DOS people not familiar with unix
#
alias cls       clear
alias copy      cp
alias del       rm
alias dir       ls -l
alias md        mkdir
alias rd        rmdir
alias ren       mv
alias edit      vi
alias list      more

setenv	EDITOR	vi
setenv	PAGER	more
setenv	BLOCKSIZE	K

if ($?prompt) then
	# An interactive shell -- set some stuff up
	set filec
	set history = 100
	set savehist = 100
	set mail = (/var/mail/$USER)

	# make mail(1) happy:
	setenv	crt	24

	set user = `whoami`
	if ($user == monitor) then
		set prompt="monitor% "
		cd ~/drawbridge
	else if ($user == manager) then
		set prompt="manager% "
		cd ~/drawbridge
	else if ($user == root) then
		set prompt="root# "
	endif
endif
