#!/bin/sh

# This script will automatically determine the inside and outside interfaces
# using the following logic:  If one interface has an IP address assigned, 
# it will be the inside interface.  If neither interface has an IP address, 
# the first interface (as returned by ifconfig -a) will be the inside 
# interface.  This behavior may be overridden by setting the following
# variables to the appropriate interface.
INSIDE_IF=
OUTSIDE_IF=

# The listen interface may be set to 'none', 'inside', 'outside', or 'both'.
# If you are planning to compile filters on this system, you should set
# LISTEN_IF to the side that your DNS server is on.  When 'none' is specified,
# *no* packets from either interface will be passed up to the kernel.  This
# will cause DNS lookups to fail and you will have to use IP addresses 
# instead of host names in the filter config file.
LISTEN_IF=inside

# Syslog log facility and Drawbridge log mask
LOG_FACILITY=local0
LOG_MASK=0

# Compiled filter configuration file
FILTERS_FILE=/usr/local/drawbridge/etc/db_filters

# Discard flags to set (see the MANAGER doc file for details)
DISCARD_FLAGS=""

# --------------- #

if [ x"$1" = x"stop" ]; then
	dbmgr stop
	exit 0
fi
[ x"$1" = x"start" ] && echo -n ' drawbridge'

PATH=/usr/bin:/usr/sbin:/bin:/sbin
export PATH

if [ -z "$INSIDE_IF" -o -z "$OUTSIDE_IF" ]; then

	INTERFACES=`ifconfig -a | egrep -v "^lo|^lp|^	" | cut -d: -f1`

	NUM=`echo $INTERFACES | wc -w`
	[ $NUM -lt 2 ] && \
		echo "ERROR: Did'n find two network interfaces" && exit 1
	[ $NUM -gt 2 ] && \
		echo "ERROR: Found more than two network interfaces" && exit 1

	IF_1=`echo $INTERFACES | cut -d' ' -f1`
	IF_2=`echo $INTERFACES | cut -d' ' -f2`

	INSIDE_IF=$IF_1
	OUTSIDE_IF=$IF_2
	if [ `ifconfig $IF_2 | grep -c inet` -gt 0 ]; then
		INSIDE_IF=$IF_2
		OUTSIDE_IF=$IF_1
	fi
fi

SIDE=inside
for IF in $INSIDE_IF $OUTSIDE_IF; do
	RUNNING=`ifconfig $IF`
	if [ $? -ne 0 ]; then
		echo "ERROR: Unable to find $SIDE interface '$IF'"
		exit 1
	fi
	RUNNING=`echo $RUNNING | grep -c RUNNING`
	if [ $RUNNING -eq 0 ]; then
		ifconfig $IF up > /dev/null
		if [ $? -ne 0 ]; then
			echo "ERROR: Unable to start $SIDE interface '$IF'"
			exit 1
		fi
	fi
	SIDE=outside
done

dbmgr set logFacility $LOG_FACILITY > /dev/null
dbmgr set logMask $LOG_MASK > /dev/null
dbmgr init $INSIDE_IF $OUTSIDE_IF $LISTEN_IF > /dev/null
dbmgr load filters $FILTERS_FILE > /dev/null
for FLAG in $DISCARD_FLAGS; do
	dbmgr set $FLAG discard > /dev/null
done
dbmgr start > /dev/null
