#!/bin/sh

MANAGER_UID=2000
MONITOR_UID=2001

[ ! _$2 = _"POST-INSTALL" ] && exit 0

# ========================================================================
# Generate the file /etc/rc.conf.local
# ========================================================================
LRCFILE=/etc/rc.conf.local
echo "##########################################################" > $LRCFILE
echo "###  Drawbridge options (overrides options in rc.conf) ###" >> $LRCFILE
echo "##########################################################" >> $LRCFILE
echo  >> $LRCFILE
echo local_startup=\"/usr/local/drawbridge/etc/rc.d \$local_startup\" >> $LRCFILE
echo inetd_enable=\"NO\" >> $LRCFILE
echo portmap_enable=\"NO\" >> $LRCFILE
echo router_enable=\"NO\" >> $LRCFILE
echo sendmail_enable=\"NO\" >> $LRCFILE
echo syslogd_flags=\"-s\" >> $LRCFILE


# ========================================================================
# Modify the file /etc/crontab
# ========================================================================
[ ! -e /etc/crontab.orig ] && mv /etc/crontab /etc/crontab.orig
sed	-e "/^# do daily.*maintenance$/i\\
# For Drawbridge, the sendmail daemon is not running.\\
# This will process outgoing mail once an hour in case any gets queued.\\
0	*	*	*	*	root	/usr/sbin/sendmail -q\\
#\\
# Since Drawbridge is not a multi-user system, it is not necessary, and\\
# may be disruptive, to perform the standard maintenance tasks so they\\
# have been commented out.\\
"	-e "s/\(^0.*daily.*\)/#\1/" \
	-e "s/\(^30.*weekly.*\)/#\1/" \
	-e "s/\(^30.*monthly.*\)/#\1/" /etc/crontab.orig > /etc/crontab


# ========================================================================
# Modify the file /etc/syslog.conf
# ========================================================================
[ ! -e /etc/syslog.conf.orig ] && mv /etc/syslog.conf /etc/syslog.conf.orig
sed -e "s/lpr.info;mail.crit;news.err/lpr.info;mail.crit;local0.none/" \
    -e "/^\*\.err.*root$/ i\\
local0.*					/var/log/drawbridge
" /etc/syslog.conf.orig > /etc/syslog.conf
touch /var/log/drawbridge
chown $MANAGER_UID.$MONITOR_UID /var/log/drawbridge
chmod 640 /var/log/drawbridge

# ========================================================================
# Modify the file /etc/newsyslog.conf
# ========================================================================
[ ! -e /etc/newsyslog.conf.orig ] && \
	mv /etc/newsyslog.conf /etc/newsyslog.conf.orig
cp -f /etc/newsyslog.conf.orig /etc/newsyslog.conf
echo "# Added for Drawbridge" >> /etc/newsyslog.conf
echo "/var/log/drawbridge			664  7     *    24    Z" >> /etc/newsyslog.conf


# ========================================================================
# Modify the file /etc/host.conf
# ========================================================================
[ ! -e /etc/host.conf.orig ] && mv /etc/host.conf /etc/host.conf.orig
echo "# Default is to use /etc/hosts file first" > /etc/host.conf
echo "hosts" >> /etc/host.conf
echo "# If that doesn't work, then try the the nameserver" >> /etc/host.conf
echo "bind" >> /etc/host.conf


# ========================================================================
# Add the drawbridge device to /dev/MAKEDEV.local
# ========================================================================
[ ! -e /dev/MAKEDEV.local.orig ] &&
	mv /dev/MAKEDEV.local /dev/MAKEDEV.local.orig
sed -e "s|^\(PATH=.*\)|\1:/usr/sbin:\$PATH|" \
    -e "/^case \$i in$/a\\
\\
drawbridge)\\
\	mknod drawbridge c 20 0\\
\	chown $MANAGER_UID.$MONITOR_UID drawbridge\\
\	chmod 640 drawbridge\\
\	;;\\
" /dev/MAKEDEV.local.orig > /dev/MAKEDEV.local
chmod 555 /dev/MAKEDEV.local


# ========================================================================
# Fixup the root, manager, and monitor Home Directories
# ========================================================================

[ ! -e /root/.cshrc.orig ] && mv /root/.cshrc /root/.cshrc.orig
cp -f dot.cshrc /root/.cshrc
cp -f dot.cshrc /home/manager/.cshrc
cp -f dot.cshrc /home/monitor/.cshrc
ln -s /usr/local/drawbridge /root/drawbridge
ln -f -s /usr/local/drawbridge /home/manager/drawbridge
ln -f -s /usr/local/drawbridge /home/monitor/drawbridge
> /home/manager/.rhosts
> /home/monitor/.rhosts
mkdir /home/manager/.ssh
mkdir /home/monitor/.ssh
> /home/manager/.ssh/authorized_keys
> /home/monitor/.ssh/authorized_keys
chown -R $MANAGER_UID.$MANAGER_UID /home/manager
chown -R $MONITOR_UID.$MONITOR_UID /home/monitor
chown -h $MANAGER_UID.$MANAGER_UID /home/manager/drawbridge
chown -h $MONITOR_UID.$MONITOR_UID /home/monitor/drawbridge

# ========================================================================
# Replace the boot sector so the -c in the boot.config file will work
# ========================================================================

[ ! -e /usr/mdec/boot1.orig ] && mv /usr/mdec/boot1 /usr/mdec/boot1.orig
[ ! -e /usr/mdec/boot2.orig ] && mv /usr/mdec/boot2 /usr/mdec/boot2.orig
install -c -o bin -g bin -m 444 boot1 /usr/mdec/boot1
install -c -o bin -g bin -m 444 boot2 /usr/mdec/boot2
disklabel -B wd0 > /dev/null 2>&1
disklabel -B sd0 > /dev/null 2>&1
cp -f firstboot.sh /usr/local/drawbridge/etc/rc.d
chmod 700 /usr/local/drawbridge/etc/rc.d/firstboot.sh
echo "-c" > /boot.config

# ========================================================================
# Done
# ========================================================================

exit 0
