/* GuileConsole.h --- gconsole wrapper
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "GuileConsole.h"
#include "gconsole.h"

@implementation GuileConsole
static GuileConsole * shared_guile_console = nil;
+ (GyveGUI *)sharedObject
{
  if (nil == shared_guile_console)
    shared_guile_console = [[self alloc] init];
  return shared_guile_console;
}
- init
{
  widget = gconsole_new("gyve> ", "hello gyve\n");
  [super init];
  gtk_widget_hide(widget);
  return self;
}
@end


void
guile_console_show()
{
  [[GuileConsole sharedObject] show];
}  

void
guile_console_hide()
{
  [[GuileConsole sharedObject] hide];
}
  
GuileConsole *
guile_console()
{
  return shared_guile_console;
}
