/* Gyve.h --- The definition for application object

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_H

#define GYVE_H 

#include <gyve/constant.h>

#include <gtk/gtk.h>

#include <DPS/dpsfriends.h>

#include <gyve/GyveTool.h>

@class NSBundle, GuileInterpreter, GuileConsole;
@class GyveBuffer, GyveWindow;
@class PSPaintStyle;
@class PSTextStyle;
@class NSArray;
@class NSSet;

enum GUI_mode 
{
  GUI_interactive_mode = 0, /* mouse in GUI parts */
  document_implicit_mode, /* mouse in a document window */
  batch_mode
};
   
@interface Gyve: NSObject
{
  /* gyveȤȤ˥󥹥ȡ뤵ХɥϤ٤ SYSTEM_BUNDLE_ROOT
     餿Ȥ褦ˤ. */
  NSBundle * system_root_bundle;

  /* scriptɾϤ٤GUILE_INTERPRETERԤʤ褦ˤ. 
      consoleɾ⤳ͳ褦ѹ٤⤷ʤ. 
     - masatake */
  GuileInterpreter * guile_interpreter;

  /*  DPSContext */
  DPSContext shared_dps_context;
  
  /* */
  NSMutableDictionary * figures_register;

  /* */
  enum GUI_mode mode;

  GtkWidget * pbar;
}
- (id)initWithArguments:(char **)_argv count:(int)_argc environment:(char **)_env;
/*
  
 */
+ (Gyve *)application;
- (void)dealloc;
- (void)run;
- (enum GUI_mode)mode;
- (void)setMode:(enum GUI_mode)m;
- (DPSContext)sharedDPSContext;
- (NSMutableDictionary *) figureRegister;
@end

@interface Gyve(GuileService)
- (GuileInterpreter *)guileInterpreter;
- (BOOL)loadScriptFile: (NSString *)str;
- (BOOL)loadInitScriptFile;
@end

@interface Gyve(BundleService)
- (NSBundle *)systemRootBundle;
@end


/*
 * Notification
 */
extern NSString * GyveDocumentWindowWillChangeNotification;
extern NSString * GyveDocumentWindowDidChangeNotification;

extern NSString * GyveDocumentWindowWillBeAddedNotification;
extern NSString * GyveDocumentWindowWasAddedNotification;

/*
 * TMP
 */
void gyve_copy_for_key(NSString * key);
void gyve_cut_for_key(NSString * key);
void gyve_paste_for_key(NSString * key);
/*
 * Exception
 */ 
#endif /* Not def: GYVE_H */
