/* GyveBuffer.h --- The definition for layers

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_BUFFER_H
#define GYVE_BUFFER_H 

#include <gyve/constant.h>
#include <gyve/PSFigObj.h>
#include <gyve/GyveGUI.h>
#include <gyve/geometry.h>
#include <gyve/containing.h>
#include <gyve/PSText.h>

#include <Foundation/NSArray.h>

/*        drawing  ->
   index of Array: 0 1 2 3 ... n
        <- down  bottom       top ->up
		              <- figure object writing down */

@class GyveLayer, GyveSelectionsLayer;
@class PSFigObjGroup, PSFigObjSelectedProxy;
@class NSString;

@class GyveBuffer;
@protocol GyveBuffersObserver
- (void)addedBuffer: (GyveBuffer *)buffer;
- (void)removedBuffer: (GyveBuffer *)buffer;
- (void)changeBufferTo: (GyveBuffer *)buffer1 from: (GyveBuffer *)buffer2;
@end

extern NSString * GyveBufferWrongSelectionException;
@interface GyveBuffer: GyveArray<LayerContaining, FigObjsContaining>
{
  GyveSelectionsLayer * selections_layer;
  int width, height;
  NSString * name;
  NSString * file_path;
@private
  BOOL changed_since_last_drawing;
  int buffer_ID;
}
// Buffer ID 
+ (void)addBufferObserver: (NSObject<GyveBuffersObserver>*)observer;
+ (void)removeBufferObserver: (NSObject<GyveBuffersObserver>*)observer;
+ (int)issueBufferIDFor: (GyveBuffer *)buffer;
+ (GyveBuffer *)bufferFromID:(int)bufferID;
+ (void)setCurrentBuffer:(GyveBuffer *)buffer; 
+ (GyveBuffer * )currentBuffer;
+ (GyveBuffer * )lookUpBufferByName: (NSString *)name;
- (int)bufferID;

// Create and destory
- initWithWidth:(int)w height: (int)h name: (NSString *)n;
- initWithWidth:(int)w height: (int)h name: (NSString *)n layer: (GyveLayer *)layer;
- (void)dealloc;

// Properties
- (NSString *)bufferName;
- (int)bufferHeight;		// In X or DPS?(TODO)
- (int)bufferWidth;

// Operations on Figures
/* EDIT

   0. ޷򤹤 selectoins_layer(GyveSelectionsLayer). 
   
   0. 򤵤Ƥ޷ΤߤԽǽ
      򡤤ϵϿundoǤ褦ˤ. 
   -selectFigObj:
   -unSelectAll

   3. ޷ɲ
   -putFigObj:
   
   ɲä޷ϼưŪ򤵤. 
   
   4. 
   -unSelectAll

   5. 
   򤷤Ƥ޷ΤߤǤ. 
   -deleteSelections
   
   5. 򤷤Ƥ޷Խ褦Ȥˤɬפ. 
   
   ˡˤ2Ĥ. 
   5.1. ʣ, ʣФԽ򳫻Ϥ롥
   -beginModificationByCopyOfFigObj:
   ԽǽcopyֵѤ. 

   5.2. Ƥ޷촹. 뤤ϽƤ޷Խ. 
   -beginModificationOfFigObj:WithNewTarget:
   
   ξundoǤ褦˥ꥸʥϼưŪ¸. 

   6. Խνλɬפ. 
   -endModificationOfFigObj:
   Υ᥽åɤˤХåե˽񤭲. +³+. 
   
   ޤ, β, Խνλ̣. 
   -unSelectAll

   7. ڥ졼Υ롼ײؤ롥
   ȥåץ٥Υ롼פundo, redo
   ʬȤ invoke 롥
   롼פκǽ-beginOperation. 
   Υ᥽åɤֵͤ
   -endOperation: Ϳƥ롼פκǸȤ.

   -beginOperation
   -endOperation:

   8. TODO 촹ˤĤƹͤƤʤ. */

- (int)beginOperation;
- (void)endOperation: (int) op;
- (GyveLayer *) layerContainsFigObj: (id<PSFigObj>)figobj;
- (BOOL) containsFigObj: (id<PSFigObj>)figobj;
- (PSFigObjSelectedProxy*)putFigObj: (id<PSFigObj>)figobj;
/* wrong method name */
- (void)deleteFigObj: (id<PSFigObj>)figobj;
- (PSFigObjSelectedProxy*)selectFigObj: (id<PSFigObj>)figobj;
- (void)unSelect: (id<PSFigObj>)figobj;
- (void)unSelectAll;

// Operations on Layers 
- (int)countLayers;
- (BOOL)containsLayer: (GyveLayer *)layer;
- (int)indexOfLayer: (GyveLayer *)layer;
- (GyveLayer *)layerAtIndex: (int)n;
- (void)removeLayer: (GyveLayer *)layer;
- (void)removeLayerAtIndex: (int)n;
- (void)insertLayer: (GyveLayer *)layer atIndex: (int)n;
- (void)addNewLayerOnTop;

/* Return YES if succeed.
   Return NO if failed. The reason of failure may be 
   that be is too small or too large */
- (BOOL)duplicateLayerAtIndex:  (int)n;
- (BOOL)moveToTopLayerAtIndex: (int)n; // Wrong method name
- (BOOL)moveUpLayerAtIndex: (int)n;
- (BOOL)moveDownLayerAtIndex:  (int)n;
- (BOOL)moveToBottomLayerAtIndex: (int)n;
- (void)falltenLayers;
- (void)mergeVisibleLayers;
- (GyveLayer *)firstLayer;
- (GyveLayer *)lastLayer;

/* Operations on Selections Layer */
- (GyveLayer *)selectionsLayerSnapShot;
- (GyveSelectionsLayer *)selectionsLayer;
- (int)countSelectedFigObjs;
- (PSFigObjSelectedProxy *)selectedFigObjAtIndex: (int)n;
- (BOOL)beginModificationByCopyOfAll;
- (BOOL)endModificationOfAll;

// Help for Drawing
- (void)changedSinceLastDrawing: (BOOL)flag;
- (BOOL)isChangedSinceLastDrawing;

// TMP
- (BOOL)_expandFigObj: (PSFigObjGroup *)figobj_group;
- (BOOL)_expandText: (id<PSText>)text inRange: (NSRange *)range;
- (void)_deleteFigObjInternal:  (id<PSFigObj>)figobj;
- (void)_replaceFigObj:  (id<PSFigObj>)old 
	    withFigObj: (id<PSFigObj>)new 
	       atLayer: (GyveLayer *)layer0;

- (GyveLayer *)topLayerToWrite;
@end

@interface BuffersMenu: GyveGUI<GyveBuffersObserver>
{
@public
  void * data;
  void * handler;
}
- initWithHandler: (void *)_handler data: (void *)_data;
- (void)addedBuffer: (GyveBuffer *)buffer;
- (void)removedBuffer: (GyveBuffer *)buffer;
- (void)changeBufferTo: (GyveBuffer *)buffer1 from: (GyveBuffer *)buffer2;
@end
#endif /* Not def: GYVE_BUFFER_H */
