/* GyveCanvas.h --- The definition for gyve canvas

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_CANVAS_H
#define GYVE_CANVAS_H 

#include <gyve/constant.h>
#include <gyve/GyveView.h>
#include <gyve/GyveEventHandler.h>

#include <gdk/gdktypes.h>

/* GyveCanvas:
   GyveViewεǽ˲ä, ޤޤ(ޥ)٥Ȥ
   event handlerΤ뵡ǽ. */

@interface GyveCanvas: GyveView
{
  NSObject <GyveEventHandler>* event_handler;
}
- initWithViewWidth: (int)w_x height: (int)h_x;
- (NSObject <GyveEventHandler>*)eventHandler;
- (void)setEventHandler:(NSObject <GyveEventHandler>*)handler;
@end

@interface GyveCanvas(Protected)
- (void)setupSignalHandler;
- (void)buttonPressEvent:   (GdkEventButton * )e;
- (void)buttonReleaseEvent: (GdkEventButton *) e;
- (void)motionNotifyEvent:  (GdkEventMotion *)e;
- (void)enterNotifyEvent:   (GdkEventCrossing *) e;
- (void)leaveNotifyEvent:   (GdkEventCrossing *) e;
- (void)keyPressEvent: (GdkEventKey *) e;
- (void)keyReleaseEvent: (GdkEventKey *) e;
@end
#endif /* Not def: GYVE_CANVAS_H */
