/* GyveView.m --- The definition for gyve canvas

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "GyveCanvas.h"
#include "draw.h"

#include <stdio.h>

#include <DPS/dpsfriends.h>

static void button_press_handler    (GtkWidget *widget, 
				     GdkEventButton *event, 
				     gpointer data);
static void button_release_handler  (GtkWidget *widget, 
				     GdkEventButton *event, 
				     gpointer data);
static void button_release_handler  (GtkWidget *widget, 
				     GdkEventButton *event, 
				     gpointer data);
static void motion_notify_handler   (GtkWidget *widget, 
				     GdkEventMotion *event, 
				     gpointer data);
static void enter_notify_handler    (GtkWidget *widget, 
				     GdkEventCrossing *event, 
				     gpointer data);
static void leave_notify_handler    (GtkWidget *widget, 
				     GdkEventCrossing *event, 
				     gpointer data);
static void key_press_handler       (GtkWidget *widget,
				     GdkEventKey *event,
				     gpointer data);
static void key_release_handler     (GtkWidget *widget,
				     GdkEventKey *event,
				     gpointer data);


@implementation GyveCanvas
- initWithViewWidth: (int)w_x height: (int)h_x
{
  [super initWithViewWidth: w_x height: h_x];
  event_handler = nil;
  return self ;
}
- (NSObject <GyveEventHandler>*)eventHandler
{
  return event_handler;
}
- (void)setEventHandler:(NSObject <GyveEventHandler>*)handler
{
  if (handler && (handler != event_handler))
    [event_handler release], event_handler = [handler retain];
}
- (void)dealloc
{
  if (event_handler) [event_handler release], event_handler = nil;
  [super dealloc];
}
@end


@implementation  GyveCanvas(Protected)
- (void)setupSignalHandler
{
  gint new_additional_mask, old_mask;

  [super setupSignalHandler];
  
  gtk_signal_connect(GTK_OBJECT([self dpsAreaWidget]), "button_press_event",
		     GTK_SIGNAL_FUNC (button_press_handler),
		     self);
  gtk_signal_connect(GTK_OBJECT([self dpsAreaWidget]), "button_release_event",
		     GTK_SIGNAL_FUNC (button_release_handler),
		     self);
  gtk_signal_connect(GTK_OBJECT([self dpsAreaWidget]), "motion_notify_event",
		     GTK_SIGNAL_FUNC (motion_notify_handler),
		     self);
  gtk_signal_connect(GTK_OBJECT([self dpsAreaWidget]), "enter_notify_event",
		     GTK_SIGNAL_FUNC (enter_notify_handler),
		     self);
  gtk_signal_connect(GTK_OBJECT([self dpsAreaWidget]), "leave_notify_event",
		     GTK_SIGNAL_FUNC (leave_notify_handler),
		     self);
  gtk_signal_connect(GTK_OBJECT([self dpsAreaWidget]), "key_press_event",
		     GTK_SIGNAL_FUNC (key_press_handler),
		     self);
  gtk_signal_connect(GTK_OBJECT([self dpsAreaWidget]), "key_release_event",
		     GTK_SIGNAL_FUNC (key_release_handler),
		     self);

  old_mask = gtk_widget_get_events(GTK_WIDGET([self dpsAreaWidget]));
  new_additional_mask = 
    GDK_BUTTON_PRESS_MASK|
    GDK_BUTTON_RELEASE_MASK|
    GDK_POINTER_MOTION_MASK|
    GDK_ENTER_NOTIFY_MASK|
    GDK_LEAVE_NOTIFY_MASK|
    GDK_KEY_PRESS_MASK |
    GDK_KEY_RELEASE_MASK;
  gtk_widget_set_events(GTK_WIDGET([self dpsAreaWidget]), old_mask|new_additional_mask);
  
  GTK_WIDGET_SET_FLAGS(GTK_WIDGET([self dpsAreaWidget]), GTK_CAN_FOCUS);
}
- (void)buttonPressEvent:   (GdkEventButton * )e 
{
  [event_handler buttonPressEvent: e onCanvas: self];
}
- (void)buttonReleaseEvent: (GdkEventButton *) e 
{
  [event_handler buttonReleaseEvent: e onCanvas: self];
}
- (void)motionNotifyEvent:  (GdkEventMotion *)e 
{
  [event_handler motionNotifyEvent: e onCanvas: self];
}
- (void)enterNotifyEvent:   (GdkEventCrossing *) e 
{
  [event_handler enterNotifyEvent: e onCanvas: self];
}
- (void)leaveNotifyEvent:   (GdkEventCrossing *) e 
{
  // fprintf(stderr, "leave notify\n");
  [event_handler leaveNotifyEvent: e onCanvas: self];
}
- (void)keyPressEvent: (GdkEventKey *) e 
{
  [event_handler keyPressEvent: e onCanvas: self];
}
- (void)keyReleaseEvent: (GdkEventKey *) e 
{
  [event_handler keyReleaseEvent: e onCanvas: self];
}
@end


static void
button_press_handler    (GtkWidget *widget, 
			 GdkEventButton *event, 
			 gpointer data)
{
  [(GyveCanvas *)data buttonPressEvent: event];
}

static void 
button_release_handler  (GtkWidget *widget, 
			 GdkEventButton *event, 
			 gpointer data)
{
  [(GyveCanvas *)data buttonReleaseEvent: event];
}


static void
motion_notify_handler   (GtkWidget *widget, 
			 GdkEventMotion *event, 
			 gpointer data)
{
  [(GyveCanvas *)data motionNotifyEvent: event];
}

static void
enter_notify_handler    (GtkWidget *widget, 
			 GdkEventCrossing *event, 
			 gpointer data)
{
  [(GyveCanvas *)data enterNotifyEvent: event];
}

static void
leave_notify_handler    (GtkWidget *widget, 
			 GdkEventCrossing *event, 
			 gpointer data)
{
  [(GyveCanvas *)data leaveNotifyEvent: event];
}

static void
key_press_handler       (GtkWidget *widget,
			 GdkEventKey *event,
			 gpointer data)
{
  [(GyveCanvas *)data keyPressEvent: event];
}

static void
key_release_handler     (GtkWidget *widget,
			 GdkEventKey *event,
			 gpointer data)
{
  [(GyveCanvas *)data keyReleaseEvent: event];
}
  
