/* GyveCreatingTool.h --- Creating tools

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_CREATING_TOOL_H
#define GYVE_CREATING_TOOL_H 
#include <gyve/GyveTool.h>
#include <gyve/PSFigObj.h>

@class PSFigObjSelectedProxy, PSPath, PSSegment;
@interface GyveSimpleCreatingTool: GyveTool
/* subclass responsibility */
- (id<PSFigObj>)createFigObjInRect: (NSRect *)rect;
- (void)drawTemporaryFigObjInRect: (NSRect *)rect;
- (NSRect)calcRect;
// 
- (void)buttonPressEvent: (GdkEventButton * )event
		onCanvas: (GyveCanvas *)canvas
		 atPoint: (NSPoint *)point 
	      withBuffer: (GyveBuffer *)buffer;
- (void)buttonReleaseEvent:(GdkEventButton *)event 
			onCanvas: (GyveCanvas *)canvas
			atPoint: (NSPoint *)point 
		withBuffer: (GyveBuffer *)buffer;
- (void)dragNotifyEvent: (GdkEventMotion *)event 
	       onCanvas: (GyveCanvas *)canvas
		atPoint: (NSPoint *)point 
	     withBuffer: (GyveBuffer *)buffer;
@end

@interface GyveRectangleTool: GyveSimpleCreatingTool
- (id<PSFigObj>)createFigObjInRect: (NSRect *)rect;
- (void)drawTemporaryFigObjInRect: (NSRect *)rect;
- (void)drawRect: (NSRect *)rect;
- (NSRect)calcRect;
@end

@interface GyveCenteredRectangleTool: GyveRectangleTool
- (NSRect)calcRect;
@end

@interface GyveOvalTool: GyveSimpleCreatingTool
- (id<PSFigObj>)createFigObjInRect: (NSRect *)rect;
- (void)drawTemporaryFigObjInRect: (NSRect *)rect;
- (void)drawOval: (NSRect *)rect;
- (NSRect)calcRect;
@end

@interface GyveCenteredOvalTool: GyveOvalTool
- (NSRect)calcRect;
@end

@interface GyvePenTool: GyveTool
{
  PSPath * path;
  PSFigObjSelectedProxy * path_proxy;
  NSPoint base_point;
  PSSegment * last_segment;
  BOOL new;
}
@end

/* Sample Implementation */
@interface GyveScriptableCreatingTool: GyveSimpleCreatingTool
+ (void)setDelegateScriptName: (NSString *)n;
- (id<PSFigObj>)createFigObjInRect: (NSRect *)rect;
- (void)drawTemporaryFigObjInRect: (NSRect *)rect;
- (NSRect)calcRect;
@end
#endif /* Not def: GYVE_CREATING_TOOL_H */
