/* GyveDrawingEngine.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_DRAWING_ENGINE_H
#define GYVE_DRAWING_ENGINE_H 

#include <gyve/constant.h>
#include <Foundation/NSGeometry.h>
#include <Foundation/NSObject.h>
#include <gtkDPS/gtkDPSarea.h>
#include <gyve/PSFigObj.h>
#include <gyve/PSText.h>
#include <gyve/geometry.h>

enum drawing_mode
{
  ARTWORK_MODE = 0,
  PREVIEW_MODE
};

@class PSFigObjSelectedProxy;

@protocol GyveDrawingEngine
- (void)setAbsoluteScale:(float) scale;
- (float)absoluteScale;
- (void)redrawRect: (NSRect *)rect;
- (enum drawing_mode)drawingMode;
- (void)setDrawingMode: (enum drawing_mode)mode;
- (void)imageCacheRequestWithArea: (GtkDPSArea * )area
			  coordTr: (struct coord_tr *)_coord_tr;
- (void)coordTrChangesTo: (struct coord_tr *)coord_tr;
- (void)setDocumentSize: (NSSize *) size;
- (NSSize)documentSize;
- (BOOL)calcBBoxOfFigObj: (NSObject<PSFigObj>*)figobj;
@end

@class GyveBuffer, GyveLayer;
@class PSPath;
@class PSImage;
@class PSFigObjGroup, PSMaskedFigObjGroup, PSCompoundPaths;
@class PSPaintStyle, PSTextStyle;

enum drawing_engine_phase 
{
  DRAWING_DOCUMENT_LAYERS = 1,
  DRAWING_SELECTIONS_LAYER,
  DRAWING_GRIDS_LAYER,
  DRAWING_NOTHING_NOW
};

@class DrawingEngineCache;
@interface GyveDrawingEngine: NSObject<GyveDrawingEngine>
{
  float absolute_scale;
  GyveBuffer * buffer;
  enum drawing_engine_phase drawing_phase;  
  enum drawing_mode drawing_mode;
  PSPaintStyle * paint_style;
  PSTextStyle * text_style;
  DrawingEngineCache * image_cache;
  NSSize document_size;

  NSObject<PSFigObj>* current_figobj_root;
  PSFigObjSelectedProxy * current_figobj_proxy;

  BOOL tool_draw;
  int tool_draw_request;
}
- initWithBuffer: (GyveBuffer *)b;
- (void)setDocumentSize: (NSSize *) size;
- (NSSize)documentSize;
- (void)redrawRect: (NSRect *)rect;
- (BOOL)calcBBoxOfFigObj: (NSObject<PSFigObj>*)figobj;
- (void)dealloc;
- (enum drawing_mode)drawingMode;
- (void)setDrawingMode: (enum drawing_mode)mode;
- (void)imageCacheRequestWithArea: (GtkDPSArea * )area
			  coordTr: (struct coord_tr *)_coord_tr;
- (void)coordTrChangesTo: (struct coord_tr *)coord_tr;
@end

@interface GyveDrawingEngine(Protected)
- (void)setTextStyle: (PSTextStyle *)new_style;
- (void)setPaintStyle: (PSPaintStyle *)new_style;
- (void)setUpDocumentLayersDrawing;
- (void)setUpSelectionsLayerDrawing;
- (void)redrawBBox: (struct bbox*)bbox ofLayer: (GyveLayer *)layer;
- (void)drawDocumentFrame;
- (void)drawFigObj: (NSObject<PSFigObj>*)figobj;
- (void)drawPath: (PSPath *)path;
- (void)drawToolRequest: (int)request forPath: (PSPath *)path;
- (void)drawText: (NSObject<PSText>*)text;
- (BOOL)calcBBoxOfText: (NSObject<PSText>*)text;
- (void)drawImage: (PSImage *)image;
- (void)drawTextAtPoint: (PSTextAtPoint *)text;
- (BOOL)calcBBoxOfTextAtPoint: (PSTextAtPoint *)text;
- (void)drawFigObjGroup: (PSFigObjGroup *)group;
- (void)drawMaskedFigObjGroup: (PSMaskedFigObjGroup *)masked_group;
- (void)drawCompoundPaths: (PSCompoundPaths *)compound_paths;
@end

void drawing_engine_send_path (PSPath *path, BOOL newpath);
void drawing_engine_send_compound_paths (PSCompoundPaths *compound_paths);
#endif /* Not def: GYVE_DRAWING_ENGINE_H */
