/* GyveEditingTool.h --- Editing tool protocol 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_EDITING_TOOL_H
#define GYVE_EDITING_TOOL_H 
#include <Foundation/NSObject.h>
#include <Foundation/NSGeometry.h>
#include <gyve/PSColor.h>
#include <gyve/GyveLayer.h>
#include <gyve/GyveTool.h>

@class GyveCanvas, GyveBuffer, GyveHitDetector, PSMatrixApplier;
@class PSPath, PSTextAtPoint, PSTextSelectedProxy;

@interface GyveEditingTool: GyveTool
{
  struct bbox init_bbox;
}
- (void)duplicateSelectedFigObjsInBuffer: (GyveBuffer *)buffer;
@end

@class PSFigObjSelectedProxy;
@interface GyveReshapeTool: GyveEditingTool
{
  GyveHitDetector * hit_detector;
  NSPoint * target_point;
  PSFigObjSelectedProxy * target_proxy;
  NSPoint * other_side_target_point;
  NSPoint * neighbor_points[2]; 
}
- init;
- (int)requestForDrawingEngine;
- (void)dealloc;
- (void)firstDragNotifyEvent: (GdkEventMotion *)event 
		   onCanvas: (GyveCanvas *)canvas
		    atPoint: (NSPoint *)point 
		 withBuffer: (GyveBuffer *)buffer;
@end

@interface GyveDirectionTool: GyveEditingTool
{
  GyveHitDetector * hit_detector;
  NSPoint * target_points[2];	// 0 primary
  PSFigObjSelectedProxy * target_proxy;
  NSPoint base_point;
}
- init;
- (int)requestForDrawingEngine;
@end 

@interface GyveMatrixTool: GyveEditingTool
{
  PSMatrixApplier * matrix;
  int op;
}
- init;
- (void)dealloc;
- (int)requestForDrawingEngine;
- (void)buttonPressEvent: (GdkEventButton * )event
		onCanvas: (GyveCanvas *)canvas
		 atPoint: (NSPoint *)point 
	      withBuffer: (GyveBuffer *)buffer;
- (void)buttonReleaseEvent: (GdkEventButton * )event
		  onCanvas: (GyveCanvas *)canvas
		   atPoint: (NSPoint *)point 
		withBuffer: (GyveBuffer *)buffer;
- (void)dragNotifyEvent: (GdkEventMotion *)event 
		   onCanvas: (GyveCanvas *)canvas
		    atPoint: (NSPoint *)point 
		 withBuffer: (GyveBuffer *)buffer;
- (void)applyMatrix: (PSMatrixApplier *)m onCanvas: (GyveCanvas *)canvas;
- (void)startSessionOnCanvas: (GyveCanvas *)canvas withBuffer: (GyveBuffer *)buffer;
/* subclass responsibility */
- (void)calcMatrixWithPoint: (NSPoint *)p;
@end

@interface GyveSelectionTool: GyveMatrixTool
{
  GyveHitDetector * hit_detector;
  BOOL direction_x;
}
- (void)clickNotifyEvent: (GdkEventButton *)event 
		onCanvas: (GyveCanvas *)canvas
		 atPoint: (NSPoint *)point 
	      withBuffer: (GyveBuffer *)buffer;
- (void)calcMatrixWithPoint: (NSPoint *)p;
- (void)trySelectFigObjsOnCanvas: (GyveCanvas *)canvas
			 atPoint: (NSPoint *)point
		      withBuffer: (GyveBuffer *)buffer;
  
- (void)firstDragNotifyEvent: (GdkEventMotion *)event 
		    onCanvas: (GyveCanvas *)canvas
		     atPoint: (NSPoint *)point 
		  withBuffer: (GyveBuffer *)buffer;
@end

@interface GyveRotateTool: GyveMatrixTool
{
  float radian_sum;
}
- (void)calcMatrixWithPoint: (NSPoint *)p;
@end

@interface GyveScaleTool: GyveMatrixTool
{
  BOOL direction_x;
}
- (void)calcMatrixWithPoint: (NSPoint *)p;
@end

#endif /* Not def: GYVE_EDITING_TOOL_H */
