/* GyveEventHandler.m --- object that handles event on canvas

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_EVENT_HANDLER_H
#define GYVE_EVENT_HANDLER_H 

#include <gdk/gdktypes.h>
#include <Foundation/NSObject.h>
#include <gyve/GyveTool.h>
#include <gyve/utilities.h>

@class GyveCanvas, GyveBuffer;

@protocol GyveEventHandler
- (void)buttonPressEvent:  (GdkEventButton * )event onCanvas: (GyveCanvas *)canvas;
- (void)buttonReleaseEvent:(GdkEventButton *)event onCanvas: (GyveCanvas *)canvas;
- (void)motionNotifyEvent: (GdkEventMotion *)event onCanvas: (GyveCanvas *)canvas;
- (void)enterNotifyEvent:  (GdkEventCrossing *)event onCanvas: (GyveCanvas *)canvas;
- (void)leaveNotifyEvent:  (GdkEventCrossing *)event onCanvas: (GyveCanvas *)canvas;
- (void)keyPressEvent:     (GdkEventKey *)event      onCanvas: (GyveCanvas *)canvas;
- (void)keyReleaseEvent:   (GdkEventKey *)event      onCanvas: (GyveCanvas *)canvas;
@end

@interface GyveEventHandler: NSObject<GyveEventHandler>
{
  BOOL dragging;
  GyveBuffer * buffer;
  int button_number;
  NSObject <GyveTool> * tool;
  struct ring_counter thinner;
}
- initWithBuffer: (GyveBuffer *)b;
- (void)dealloc;
- (void)thinOutMotionEventBy: (int) n;
@end
#endif /* Not def: GYVE_EVENT_HANDLER_H */
