/* GyveEventHandler.m --- object that handles event on canvas

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "utilities.h"
#include "public.h"
#include "popup_menu.h"
#include "GyveEventHandler.h"
#include "GyveBuffer.h"
#include "GyveWindow.h"
#include "Gyve.h"
#include "GyveCanvas.h"
#include "ToolBox.h"
#include "PaintStylePallet.h"
#include <gdk/gdkkeysyms.h>
#include <gdk/gdktypes.h>

static GtkWidget *popup_menu = NULL;

@implementation  GyveEventHandler
+ (void)initialize
{
  GtkMenuEntry popup_menu_items[] =
  {
    { "<Figure>/File/Print", NULL, menu_file_print, NULL},
    { "<Figure>/Edit/Cut", NULL, menu_edit_cut, NULL},
    { "<Figure>/Edit/Copy", NULL, menu_edit_copy, NULL},
    { "<Figure>/Edit/Paste", NULL, menu_edit_paste, NULL},
    { "<Figure>/Edit/Delete", NULL, menu_edit_delete, NULL},
    { "<Figure>/Object/Group/Create", NULL, menu_group_create, NULL},
    { "<Figure>/Object/Group/Release", NULL, menu_group_release, NULL},
    { "<Figure>/Object/Mask/Create", NULL, menu_mask_create, NULL},
    { "<Figure>/Object/Mask/Release", NULL, menu_mask_release, NULL},
    { "<Figure>/Object/Compound Paths/Create", NULL, menu_compound_paths_create, NULL},
    { "<Figure>/Object/Compound Paths/Release", NULL, menu_compound_paths_release, NULL},
    { "<Figure>/Object/Image/Random", NULL, menu_image_test_random, NULL},
    { "<Figure>/Object/Image/Import Xpm", NULL, menu_image_test_xpm, NULL},
    { "<Figure>/Object/Text/GYVE Logo", NULL, menu_text_logo, NULL},
    { "<Figure>/Drawing Mode/Preview", NULL, menu_mode_preview, NULL},
    { "<Figure>/Drawing Mode/Artwork", NULL, menu_mode_artwork, NULL},
    { "<Figure>/Option/Enable Image Cache", NULL, menu_enable_imagecache, NULL},
    { "<Figure>/Option/Disable Image Cache", NULL, menu_disable_imagecache, NULL},
  };
  gint npopup_menu_items = sizeof(popup_menu_items)/sizeof(popup_menu_items[0]);
  popup_menu 		 = popup_menu_new(popup_menu_items, 
					  npopup_menu_items,
					  "<Figure>");
}
- init
{
  [self shouldNotImplement: _cmd];
  return nil;
}
- initWithBuffer: (GyveBuffer *)b
{
  [super init];
  dragging = NO;
  tool 	   = nil;
  ASSGIN_NSOBJECT(b, buffer);
  ring_counter_init(&thinner, 2);
  return self ;
}
- (void)thinOutMotionEventBy: (int) n
{
  ring_counter_set_max(&thinner, n);
}
- (void)buttonPressEvent:  (GdkEventButton * )event  onCanvas: (GyveCanvas *)canvas 
{
  NSPoint dpspoint;
  button_number = event->button;

  [GyveWindow setLastClickedWindow: [GyveWindow lookUpWindowByCanvas: canvas]];
  
  if ([buffer countSelectedFigObjs] > 0)
    {
      NSObject<PSFigObj>* primitive_figobj;
      PSPaintStyle * paint_style;
      primitive_figobj = [[buffer selectionsLayer] lastPrimitiveFigObj];
      if ([primitive_figobj respondsToSelector: @selector(paintStyle)])
	{
	  paint_style = [primitive_figobj performSelector: 
					    @selector(paintStyle)];
	  [(PaintStylePallet *)[PaintStylePallet sharedObject] 
			       installPaintStyle: paint_style];
	}
    }
  
  if (3 == button_number)
    {
      popup_menu_popup(popup_menu, event->button, event->time);
    }
  else if (2 == button_number)
    {

    }
  else
    {
      dragging = YES;
      dpspoint = [canvas translatePointFromGdkEventToDPS: (GdkEvent *)event];
      if ([canvas dpsContextBegin])
	if (tool) [tool buttonPressEvent: event
			onCanvas: canvas
			atPoint: &dpspoint
			withBuffer: buffer];
      [canvas dpsContextEnd];
    }
}
- (void)buttonReleaseEvent:(GdkEventButton *)event   onCanvas:(GyveCanvas *)canvas
{
  NSPoint dpspoint;
  button_number = event->button;
  if (3 == button_number)
    {
      // For menu
    }
  else if (2 == button_number)
    {
      
    }
  else
    {
      dpspoint = [canvas translatePointFromGdkEventToDPS: (GdkEvent *)event];
      if ([canvas dpsContextBegin])
	if (tool) [tool buttonReleaseEvent: event
			onCanvas: canvas
			atPoint: &dpspoint
			withBuffer: buffer];
      [canvas dpsContextEnd];
    }
  dragging = NO;
}
- (void)motionNotifyEvent: (GdkEventMotion *)event onCanvas:(GyveCanvas *)canvas
{
  NSPoint dpspoint;

  ring_counter_inc (&thinner);
  if (NO == ring_counter_is_striking(&thinner)) return;

  if (3 == button_number)
    {
      // For menu
    }
  else if (2 == button_number)
    {
    }
  else
    {
      dpspoint = [canvas translatePointFromGdkEventToDPS: (GdkEvent *)event];
      if ([canvas dpsContextBegin])
	{
	  if (YES == dragging)
	    {
	      if (tool) [tool dragNotifyEvent: event
			      onCanvas: canvas
			      atPoint: &dpspoint
			      withBuffer: buffer];
	    }
	  else
	    {
	      if (tool) [tool motionNotifyEvent: event
			      onCanvas: canvas
			      atPoint: &dpspoint
			      withBuffer: buffer];
	    }
	}
      [canvas dpsContextEnd];
    }
}
- (void)enterNotifyEvent:  (GdkEventCrossing *)event onCanvas:(GyveCanvas *)canvas
{
  NSObject <GyveTool> * new_tool = [ToolBox tool];
  GyveCanvas * old_canvas = [[GyveWindow currentWindow] contentCanvas];
  GyveBuffer * old_buffer = [[GyveWindow currentWindow] contentBuffer];
  GyveCanvas * new_canvas = canvas;
  [[Gyve application] setMode: document_implicit_mode];
      
  if ((NO == dragging) 
      && ((old_canvas != new_canvas) || new_tool != tool))
    {
      if (tool)
	{
	  [old_canvas dpsContextBegin];
	  [tool finishSessionOnCanvas: old_canvas withBuffer: old_buffer];
	  [old_canvas dpsContextEnd];
	}
      ASSGIN_NSOBJECT(new_tool, tool);
      [GyveWindow setCurrentWindow: [GyveWindow lookUpWindowByCanvas: canvas]];
      if (tool)
	{
	  [canvas dpsContextBegin];
	  [tool startSessionOnCanvas: canvas withBuffer: buffer];
	  [canvas dpsContextEnd];
	}
    }
}
- (void)leaveNotifyEvent:  (GdkEventCrossing *)event onCanvas:(GyveCanvas *)canvas
{
}
- (void)keyPressEvent:     (GdkEventKey *)event      onCanvas:(GyveCanvas *)canvas
{
  if ([canvas dpsContextBegin])
    {
      if (tool)
	{
	  int c = event->keyval;
	  if (c == GDK_Return)
	    {
	      c = '\n';
	    }
	  [tool keyPressEvent:  event
		ofCharacter: c
		onCanvas:  canvas
		withBuffer: buffer];
	}
    }
  [canvas dpsContextEnd];
}
- (void)keyReleaseEvent:   (GdkEventKey *)event      onCanvas:(GyveCanvas *)canvas
{
}
- (void)dealloc
{
  [buffer release], buffer = nil;
  [tool release], tool 	   = nil;
  [super dealloc];
}
@end
