/* GyveGUI.h --- The gui related declarations

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_G_U_I_H
#define GYVE_G_U_I_H 

#include <gtk/gtk.h>
#include <Foundation/NSObject.h>
#include <Foundation/NSGeometry.h>

void gui_enter_interactive_mode ();

@protocol GyveGUI
+ (id<GyveGUI>)sharedObject;
- (void)show;
- (void)hide;
- (GtkWidget *)gtkWidget;
- (void)dealloc;
@end

@interface GyveGUI: NSObject
{
  GtkWidget * widget;
}
+ (GyveGUI *)sharedObject;
- (void)show;
- (void)hide;
- (GtkWidget *)gtkWidget;
- (void)dealloc;
@end

/*
 * GTK extensions
 */
void gtk_container_remove_all(GtkContainer * container);

/*
 * Message
 */
void gyve_message(char * msg);
void gyve_menu_not_implemented();
void gyve_button_not_implemented(GtkButton *button, gpointer data);

/*
 * Shared menu factory
 */
GtkMenuFactory * gyve_root_menu_factory();
  
#endif /* Not def: GYVE_G_U_I_H */
