/* GyveGUI.m --- The gui related codes

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "GyveGUI.h"
#include "GuileConsole.h"
#include "Gyve.h"

void
gui_enter_interactive_mode ()
{
  [[Gyve application] setMode: GUI_interactive_mode];
}

@implementation GyveGUI
+ (id<GyveGUI>)sharedObject
{
  [self subclassResponsibility: _cmd];
  return nil;
}
- (void)show
{
  gtk_widget_show(widget);
}
- (void)hide
{
  gtk_widget_hide(widget);
}
- (GtkWidget *)gtkWidget
{
  return widget;
}
- (void)dealloc
{
  gtk_widget_unref(widget);
  [super dealloc];
}
@end

/*
 * GTK extensions
 */
void
gtk_container_remove_all(GtkContainer * container)
{
  int max, i;
  GList * list = gtk_container_children(container);
  GtkWidget * item;
  max 	       = g_list_length(list);
  for (i = 0; i < max; i++)
    {
      item = (GtkWidget *)g_list_nth_data(list, i);
      gtk_container_remove(container, item);
    }
}

/*
 * Message
 */
void
gyve_message(char * msg)
{
  static int msg_id = 0;
  char msg_buf[1024];
  GtkWidget * window;
  GtkWidget * label;
  GtkWidget * button;
  GtkWidget * vbox;
  
  if (msg == NULL || *msg == '\0') return;
  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed),
		      &window);
  gtk_window_set_title (GTK_WINDOW (window), "Message");
  gtk_container_border_width (GTK_CONTAINER (window), 3);
  gtk_widget_show (window);

  vbox = gtk_vbox_new (FALSE, 0);  
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_widget_show (vbox);

  sprintf(msg_buf, "gyve[%d]:  %s", msg_id++, msg);
  label = gtk_label_new(msg_buf);
  gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);
  
  button = gtk_button_new_with_label("OK");
  gtk_signal_connect_object (GTK_OBJECT(button), "clicked",
		      GTK_SIGNAL_FUNC (gtk_widget_destroy),
		      GTK_OBJECT(window));

  gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);
  
}

void
gyve_menu_not_implemented()
{
  gyve_message("The menu item is not implemented yet.");
}

void
gyve_button_not_implemented(GtkButton *button, gpointer data)
{
  gyve_message("The button item is not implemented yet.");
}

/*
 * Menu factory
 */
static GtkMenuFactory * root_menu_factory = NULL;
GtkMenuFactory *
gyve_root_menu_factory()
{
  if (!root_menu_factory) 
    root_menu_factory = gtk_menu_factory_new (GTK_MENU_FACTORY_MENU_BAR);
  return root_menu_factory;
}
