/* GyveHitDetector.h --- class wrapping hit detecting functions
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_HIT_DETECTOR_H
#define GYVE_HIT_DETECTOR_H 

#include <base/Stack.h>
#include <Foundation/NSGeometry.h>
#include <gyve/geometry.h>
#include <gyve/PSFigObj.h>
#include <gyve/PSBBox.h>
#include <gyve/utilities.h>
#include <gyve/PSText.h>
#include <gyve/PSPath.h>
#include <gyve/GyveDrawingEngine.h>

@class GyveBuffer, GyveLayer;
@class PSPath, PSImage, PSFigObjGroup, PSMaskedFigObjGroup, PSCompoundPaths;

/*
   Stack: bottom ------------> top 
          buffer layer ...     path */


enum hit_detect_method 
{
  UNBOUND = 0,
  HIT_DETECT_UNDER_POINT,
  /* */
  HIT_DETECT_AROUND_POINT,
  HIT_DETECT_ACROSS_RECT,
};

/*
 */
enum hit_detect_depth
{
  HIT_DETECT_DEPTH_DEFAULT ,
  HIT_DETECT_DEPTH_SEGMENT     ,
  HIT_DETECT_DEPTH_ANCHOR_POINT      ,
  HIT_DETECT_DEPTH_DIRECTRION_POINT  ,
  HIT_DETECT_DEPTH_DIRECTRION_LINE,
  /* TODO: Should implement
  HIT_DETECT_DEPTH_BBOX_CENTER ,
  HIT_DETECT_DEPTH_BBOX_POINT  ,
  HIT_DETECT_DEPTH_BBOX_RECT   , */
};

@interface GyveHitDetector: Stack
{
@public
  id target;			// Not retained
  float scale;
  float radius;
@protected
  id_predicator_t * predicator;
  enum hit_detect_method method;
  enum hit_detect_depth depth;
  void * argument;
  struct floats_data coords;  
  struct DPSUserPathOps_data ops;
}
- initWithTarget: t;
- (void)setRadius: (float) r;
- (void)setTargetForHitDetectrion: t;
- (void)setAbsoluteScale:(float) s;
- secondObject;
- thirdObject;
- (BOOL)detectHitUnderPoint: (NSPoint *) point;
- (BOOL)detectHitUnderPoint: (NSPoint *) point
		      withDepth: (enum hit_detect_depth)d;
/* predicatorNO֤֥ȤФƤƤϥҥå
   ФϤʤ. */
- (BOOL)detectHitUnderPoint: (NSPoint *) point 
	 withPredicator: (id_predicator_t)p;
- (BOOL)detectHitUnderPoint: (NSPoint *) point 
	     withPredicator: (id_predicator_t)p
		      depth: (enum hit_detect_depth)d;
- (BOOL)detectHitAroundPoint: (NSPoint *) point;
- (BOOL)detectHitAroundPoint: (NSPoint *) point 
	  withPredicator: (id_predicator_t)p;
- (BOOL)detectHitAcrossRect: (NSRect *) rect;
- (BOOL)detectHitAcrossRect: (NSRect *) rect
	 withPredicator: (id_predicator_t)p;
@end

@interface GyveHitDetector(Protected)
- (BOOL)detectHitByMethod: (enum hit_detect_method)m
	     withArgument: (void *)arg
	       predicator: (id_predicator_t)p;
- (BOOL)detectHitOnTarget: _target;
- (BOOL)detectHitOnBuffer: (GyveBuffer *)buffer;
- (BOOL)detectHitOnLayer: (GyveLayer *)layer;
- (BOOL)detectHitOnFigObj: (id<PSFigObj>)figobj;
- (BOOL)detectHitOnFigObjProxy: (PSFigObjSelectedProxy *)figobj_proxy;
- (BOOL)detectHitOnPath: (PSPath *)path;
- (BOOL)detectHitOnText: (id<PSText>)text;
- (BOOL)detectHitOnTextAtPoint: (PSTextAtPoint *)text;
- (BOOL)detectHitOnImage: (PSImage *)image;
- (BOOL)detectHitOnFigObjGroup: (PSFigObjGroup *)group;
- (BOOL)detectHitOnMaskedFigObjGroup: (PSMaskedFigObjGroup *)masked_group;
- (BOOL)detectHitOnCompoundPaths: (PSCompoundPaths *)compound_paths;
@end

BOOL detect_hit_on_bbox(struct bbox * bbox, 
			enum hit_detect_method method, 
			void * arg);

BOOL detect_hit_on_point_rect(NSPoint * rectcenter,
			      float size,
			      NSPoint * hitpoint);

void hit_detector_pack_path (id<PSPath> path, 
			     struct floats_data * coords,
			     int * coords_length,
			     struct DPSUserPathOps_data * ops,
			     int * ops_length);
void hit_detector_pack_coords (id<PSPath> path,
			       struct floats_data * coords,
			       int * coords_length);
void hit_detector_pack_ops (id<PSPath> path,
			    struct DPSUserPathOps_data * ops,
			    int * ops_length);
#endif /* Not def: GYVE_HIT_DETECTOR_H */
