/* GyveLayer.h --- The definition for layers

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_LAYER_H
#define GYVE_LAYER_H 

#include <gyve/constant.h>
#include <gyve/geometry.h>
#include <gyve/PSFigObj.h>
#include <gyve/containing.h>
#include <Foundation/NSGeometry.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSRange.h>
#include <gyve/PSColor.h>
#include <Foundation/NSObject.h>

/*        drawing  ->
   index of Array: 0 1 2 3 ... n
                 bottom       top 
		              <- figure object writing down */

@class NSString, PSFigObjGroup;
extern NSString * GyveLayerNotWritableException;

@interface GyveLayer: GyveArray <FigObjsContaining, NSCopying, NSMutableCopying>
{
  NSString * name;
  BOOL printable;
  BOOL writable;
  BOOL visible;
  NSObject<PSColor> * color;
@private
  BOOL changed_since_last_drawing;
  int layer_ID;
}
/* Layer ID */
+ (int)issueLayerIDFor: (GyveLayer *)layer;
+ (GyveLayer *)layerFromID:(int)layerID;
- (int)layerID;

// Create and destory
- initWithName: (NSString *)_name;
- copyWithZone: (NSZone *)zone;
- mutableCopyWithZone: (NSZone *)zone;
- (void)dealloc;

// Properties
- (NSString *)layerName;
- (void)setLayerName: (NSString *)n;
- (id<PSColor>)layerColor;
- (void)setLayerColor: (id<PSColor>)c;	// copy
- setPrintable: (BOOL)b;
- (BOOL)isPrintable;
- setWritable: (BOOL)b;
- (BOOL)isWritable;
- setVisible: (BOOL)b;
- (BOOL)isVisible;

// Operations on figobjs
- (int)countFigObjs;
- (BOOL) containsFigObj: (id<PSFigObj>)figobj;
- (int)indexOfFigObj: (id<PSFigObj>)figobj;
- (id<PSFigObj>)figObjAtIndex: (int)n;
- (void)removeFigObj: (id<PSFigObj>)figobj;
- (void)removeFigObjAtIndex: (int)n;
- (void)insertFigObj: (id<PSFigObj>)newfig atIndex: (int)n;
- (void)addFigObjOnTop: (id<PSFigObj>)newfig;
- (int)countSelectedFigObjs;
- (int)countSelectedFigObjsBefore: (id<PSFigObj>)figobj;
- (NSRange)expandFigObj: (PSFigObjGroup *)figobj_group;

// Help for Drawing
- (void)changedSinceLastDrawing: (BOOL)flag;
- (BOOL)isChangedSinceLastDrawing;
@end

#endif /* Not def: GYVE_LAYER_H */
