/* GyveMiscTool.m --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "GyveMiscTool.h"
#include "GyveCanvas.h"
#include "GyveScrolledCanvas.h"

#include <gdk/gdkkeysyms.h>

@implementation GyveZoomTool
- (void)buttonPressEvent: (GdkEventButton * )event
		onCanvas: (GyveCanvas *)canvas
		 atPoint: (NSPoint *)point 
	      withBuffer: (GyveBuffer *)buffer
{
  float scale = [canvas absoluteScale];
  [super buttonPressEvent: event
	 onCanvas: canvas
	 atPoint: point
	 withBuffer: buffer];

  if (YES == shift)
    {
      scale = [self zoomOutScale: scale];
    }
  else
    {
      scale = [self zoomInScale: scale];
    }
  [canvas setAbsoluteScale: scale];
  [(GyveScrolledCanvas  *)canvas setViewPoint: point];
}
- (float)zoomInScale: (float)old_scale
{
  if (0.3 == old_scale)
    return 0.5;
  else if (0.5 == old_scale)
    return 0.8;
  else if (0.8 == old_scale)
    return 1.0;
  else if (1.0 == old_scale)
    return 1.5;
  else if (1.5 == old_scale)
    return 2.0;
  else if (2.0 == old_scale)
    return 3.0;
  else if (3.0 == old_scale)
    return 4.0;
  else if (4.0 == old_scale)
    return 4.0;
  else 
    return 1.0;
}
- (float)zoomOutScale: (float)old_scale
{
  if (0.3 == old_scale)
    return 0.3;
  else if (0.5 == old_scale)
    return 0.3;
  else if (0.8 == old_scale)
    return 0.5;
  else if (1.0 == old_scale)
    return 0.8;
  else if (1.5 == old_scale)
    return 1.0;
  else if (2.0 == old_scale)
    return 1.5;
  else if (3.0 == old_scale)
    return 2.0;
  else if (4.0 == old_scale)
    return 3.0;
  else 
    return 1.0;
}
@end
