/* GyveScrolledCanvas.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "GyveScrolledCanvas.h"
#include "Gyve.h"
#include "geometry.h"

static void
change_to_gui_mode(GtkWidget *widget, 
				     GdkEventCrossing *event, 
				     gpointer data)
{
  [[Gyve application] setMode: GUI_interactive_mode];
}

@implementation GyveScrolledCanvas
- initWithViewWidth: (int)w_x height: (int)h_x
{
  int border_width = 10;
  [super initWithViewWidth: w_x height:  h_x];
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_usize (scrolled_window, 
			w_x + 2*border_width + 40,
			h_x + 2*border_width + 40);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  gtk_container_border_width (GTK_CONTAINER (scrolled_window), 
			      border_width);
  gtk_container_add (GTK_CONTAINER (scrolled_window), [self dpsAreaWidget]);

  gtk_signal_connect(GTK_OBJECT(GTK_SCROLLED_WINDOW (scrolled_window)->hscrollbar),
		     "enter_notify_event",
		     GTK_SIGNAL_FUNC (change_to_gui_mode), 
		     NULL);

  gtk_signal_connect(GTK_OBJECT(GTK_SCROLLED_WINDOW (scrolled_window)->vscrollbar),
		     "enter_notify_event",
		     GTK_SIGNAL_FUNC (change_to_gui_mode), 
		     NULL);
  return self ;
}
- (void)show
{
  gtk_widget_show(scrolled_window);
  [super show];
}
- (void)hide
{
  gtk_widget_hide(scrolled_window);
}
- (GtkWidget *)gtkWidget
{
  return scrolled_window;
}
- (void)dealloc
{
  gtk_widget_destroy(scrolled_window), scrolled_window = NULL;
  [super dealloc];
}
- (GtkWidget *)scrolledWindowWidget
{
  return scrolled_window;
}
- (NSRect)dpsAppearedAreaRect
{
  NSRect rect_x;
  GtkWidget * viewport = GTK_SCROLLED_WINDOW(scrolled_window)->viewport;
  GtkAllocation allocation = viewport->allocation;
  
  NSRect_from_gtkAllocation(&rect_x, &allocation);
  return [self translateRectFromXToDPS: &rect_x];
}
- (void)setViewPoint: (NSPoint *)point_dps
{
  GtkAdjustment *hadj, *vadj;
  NSRange range = {0.0, 1.0};
  float ratio_x, ratio_y;
  float value_x, value_y;
  NSSize size = [self dpsAreaSize];
  ratio_x     = point_dps->x/size.width;
  ratio_y     = point_dps->y/size.width;
  ratio_x     = NSRange_round_by_range(&range, ratio_x);
  ratio_y     = NSRange_round_by_range(&range, ratio_y);
    
  hadj = gtk_scrolled_window_get_hadjustment(
    GTK_SCROLLED_WINDOW(scrolled_window));
  vadj = gtk_scrolled_window_get_vadjustment(
    GTK_SCROLLED_WINDOW(scrolled_window));

  value_x = (hadj->upper - hadj->lower)*ratio_x;
  gtk_adjustment_set_value(hadj, value_x);

  value_y = (vadj->upper - vadj->lower)*(1.0 - ratio_y);
  gtk_adjustment_set_value(vadj, value_y);
}
- (void)changeAreaSizeWidth: (int)w_x height: (int)h_x
{
  NSPoint point;
  NSSize size;
  [super changeAreaSizeWidth: w_x height: h_x];
  size = [self dpsAreaSize];
  point.x     = size.width/2.0;
  point.y     = size.height/2.0;
  [self setViewPoint: &point];
}
@end
