/* GyveSelectionsLayer.h --- The definition for selction special layer

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_SELECTIONS_LAYER_H
#define GYVE_SELECTIONS_LAYER_H 

#include <gyve/GyveLayer.h>
#include <gyve/PSFigObj.h>
#include <gyve/PSBBox.h>

@class NSString, GyveBuffer;
extern NSString * PSFigObjSelectedProxyMultiModification;

@interface PSFigObjSelectedProxy: PSFigObjProxy
{
  GyveLayer * layer_from;
  NSObject<PSFigObj> * backup;
  GyveBuffer * buffer;		// Not retained
}

/* Use these methods only in the classes of gyve itself */
+ proxyForFigObj: (NSObject<PSFigObj> *)figobj 
       fromLayer: (GyveLayer *)layer
	ofBuffer: (GyveBuffer *)buffer;
- (void)reinit;
- (NSObject<PSFigObj> *)originalTargetForFigObjProxy;
- (BOOL)isTargetFigObjIsChanged;
- (GyveLayer *)layer;
- (GyveBuffer *)buffer;
- (void)dealloc;

/* Order...
- (void)moveToTop;
- (void)moveForward;
- (void)moveBackward;
- (void)moveToBottom; */

- (void)unSelect;
- (void)delete;
- (void)expand;
- (NSObject<PSFigObj> *)beginModificationByCopy;
- (void)beginModificationWithNewTarget: (BYREF NSObject<PSFigObj> *)new_figobj;
- (void)endModification;
@end

@interface PSFigObjSelectedProxy(Protected)
- initForFigObj:  (NSObject<PSFigObj> *)figobj 
      fromLayer:  (GyveLayer *)layer
       ofBuffer: (GyveBuffer *)_buffer;
@end


@interface GyveSelectionsLayer: GyveLayer<PSBBox>
{
  struct bbox bbox;
}
/* Look up FIGOBJ on selections layer 
 
   1. FIGOBJ, PSFigObjSelectedProxyΥ󥹥󥹤ξ:
   FIGOBJSelectionsLayerˤФΤޤ֤. 
   ʤ, ProxytargetSelectionsLayer̤proxy
   õ, ¸ߤ, proxy֤. ʤnil򴹤. 

   2. PSFigObjSelectedProxyΥ󥹥󥹤Ǥʤ, 
   FIGOBJޤSelectionsLayerproxyõ, ¸ߤ, 
   ֤. ʤnil֤. */
- (PSFigObjSelectedProxy*)lookUpProxyForFigObj:(NSObject<PSFigObj> *)figobj;

@end

/* @category GyveSelectionsLayer(GyveBuffer)
   Use these methods only in GyveBuffer implementations 
   @end */
@interface GyveSelectionsLayer(GyveBuffer)
- init;
- (void)unSelectAll;

- (PSFigObjSelectedProxy*)putFigObj: (id<PSFigObj>)figobj
			  fromLayer: (GyveLayer *)layer
			   ofBuffer: (GyveBuffer *)buffer
			    atIndex: (int)index;
/* If there is no need to copy, return NO,
   otherwise return YES */
- (BOOL)beginModificationByCopyOfAll;
- (BOOL)endModificationOfAll;
@end

#endif /* Not def: GYVE_SELECTIONS_LAYER_H */
