/* GyveTextTool.h --- Text editing tool protocol 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_TEXT_TOOL_H
#define GYVE_TEXT_TOOL_H 

#include <gyve/GyveTool.h>
#include <Foundation/NSObject.h>

@class PSTextAtPoint;
@class PSTextSelectedProxy;

// TODO: This should be subclass of GyveTool.
@interface GyveTextTool: NSObject<GyveTool>
{
  NSPoint cursor_point;
  BOOL erasing_cursor_now;
  PSTextSelectedProxy * text_proxy;
  BOOL dragged;
  unsigned int base_location;
}
- (int)requestForDrawingEngine;
- (void)drawTextCursor;
- (void)eraseTextCursor;
- (void)drawAfterAll;
- (void)calcTextCursorPosition;
@end

#endif /* Not def: GYVE_TEXT_TOOL_H */
