/* GyveTool.h --- tool protocol 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 


#ifndef GYVE_TOOL_H
#define GYVE_TOOL_H 
#include <Foundation/NSObject.h>
#include <gdk/gdktypes.h>
#include <Foundation/NSGeometry.h>
#include <gyve/PSColor.h>
#include <gyve/GyveLayer.h>

@class GyveCanvas, GyveLayer, GyveBuffer;

enum tool_drawing_request
{
  tool_drawing_by_self_before = 1 << 1,
  tool_drawing_by_self_after = 1 << 2,
  tool_drawing_anchor_point = 1 << 3,
  tool_drawing_direction_point = 1 << 4,
  tool_drawing_direction_line = 1 << 5,
  tool_drawing_bbox_center    = 1 << 6,
  tool_drawing_bbox_rect    = 1 << 7,
  tool_drawing_bbox_point    = 1 << 8,
  tool_drawing_query = 1 << 9,
};

@protocol GyveTool
- (int)requestForDrawingEngine;
- (void)buttonPressEvent: (GdkEventButton * )event
		onCanvas: (GyveCanvas *)canvas
		 atPoint: (NSPoint *)point 
	      withBuffer: (GyveBuffer *)buffer;
- (void)buttonReleaseEvent:(GdkEventButton *)event 
			onCanvas: (GyveCanvas *)canvas
			atPoint: (NSPoint *)point 
		withBuffer: (GyveBuffer *)buffer;
- (void)motionNotifyEvent: (GdkEventMotion *)event 
		 onCanvas: (GyveCanvas *)canvas
		  atPoint: (NSPoint *)point 
	       withBuffer: (GyveBuffer *)buffer;
- (void)dragNotifyEvent: (GdkEventMotion *)event 
	       onCanvas: (GyveCanvas *)canvas
		atPoint: (NSPoint *)point 
	     withBuffer: (GyveBuffer *)buffer;
- (void)keyPressEvent:  (GdkEventKey *)event
	  ofCharacter: (int)character
	     onCanvas:  (GyveCanvas *)canvas
	   withBuffer: (GyveBuffer *)buffer;
- (void)startSessionOnCanvas: (GyveCanvas *)canvas
		  withBuffer: (GyveBuffer *)buffer;
- (void)finishSessionOnCanvas: (GyveCanvas *)canvas
		  withBuffer: (GyveBuffer *)buffer;
- (void)drawAfterAll;
- (void)drawClickPoint: (NSPoint *)p onCanvas: (GyveCanvas *)canvas;
- (void)eraseClickPoint: (NSPoint *)p onCanvas: (GyveCanvas *)canvas;
@end

@interface GyveTool: NSObject<GyveTool>
{
  BOOL after_dragging;
  BOOL shift;
  BOOL control;
  BOOL mod1;
  NSPoint start_point;
  NSPoint last_point;
  NSPoint click_point;
  GyveLayer * layer; 
}
- init;
- (int)requestForDrawingEngine;
- (void)buttonPressEvent: (GdkEventButton * )event
		onCanvas: (GyveCanvas *)canvas
		 atPoint: (NSPoint *)point 
	      withBuffer: (GyveBuffer *)buffer;
- (void)buttonReleaseEvent:(GdkEventButton *)event 
			onCanvas: (GyveCanvas *)canvas
			atPoint: (NSPoint *)point 
		withBuffer: (GyveBuffer *)buffer;
- (void)motionNotifyEvent: (GdkEventMotion *)event 
		 onCanvas: (GyveCanvas *)canvas
		  atPoint: (NSPoint *)point 
	       withBuffer: (GyveBuffer *)buffer;
- (void)dragNotifyEvent: (GdkEventMotion *)event 
	       onCanvas: (GyveCanvas *)canvas
		atPoint: (NSPoint *)point 
	     withBuffer: (GyveBuffer *)buffer;
//
- (void)firstDragNotifyEvent: (GdkEventMotion *)event 
	       onCanvas: (GyveCanvas *)canvas
		atPoint: (NSPoint *)point 
	     withBuffer: (GyveBuffer *)buffer;
- (void)draggingNotifyEvent: (GdkEventMotion *)event 
		  onCanvas: (GyveCanvas *)canvas
		   atPoint: (NSPoint *)point 
	     withBuffer: (GyveBuffer *)buffer;
- (void)endDragNotifyEvent: (GdkEventButton *)event
	       onCanvas: (GyveCanvas *)canvas
		atPoint: (NSPoint *)point 
	     withBuffer: (GyveBuffer *)buffer;
- (void)clickNotifyEvent: (GdkEventButton *)event 
		onCanvas: (GyveCanvas *)canvas
		 atPoint: (NSPoint *)point 
	      withBuffer: (GyveBuffer *)buffer;

//
- (void)startSessionOnCanvas: (GyveCanvas *)canvas
		  withBuffer: (GyveBuffer *)buffer;
- (void)finishSessionOnCanvas: (GyveCanvas *)canvas
		  withBuffer: (GyveBuffer *)buffer;
//
- (void)drawAfterAll;
//
- (NSPoint *)lastPoint;
- (NSRect)pointsRectFromPoint: (NSPoint *)p;
- (NSRect)pointsCenteredRectFromPoint: (NSPoint *)p;
- (NSPoint)pointsDiffFromPoint: (NSPoint *)p; /* last - p */
 
- (NSPoint *)startPoint;
- (NSRect)pointsRectFromStart;
- (NSRect)pointsCenteredRectFromStart;
- (NSPoint)pointsDiffFromStart; /* last - start */

- (NSPoint *)clickPoint;
- (NSRect)pointsRectFromClick;
- (NSRect)pointsCenteredRectFromClick;
- (NSPoint)pointsDiffFromClick; /* last - click */

/* the origin is click point 
       
	     + point
	    /
	   /   angle
	  / \ 
   click +-----------+ last */
- (float)pointsAngleForPoint:  (NSPoint *)p;
- (float)pointsXScaleForPoint:  (NSPoint *)p;
- (float)pointsYScaleForPoint:  (NSPoint *)p;

- (void)recordStartPoint: (NSPoint *)point;
- (void)updateLastPoint:  (NSPoint *)point;
- (void)setClickPoint: (NSPoint *)point 
	     onCanvas: (GyveCanvas *)canvas;
- (void)setLayer: (GyveLayer *)_layer;
- (GyveLayer *)layer;
- (id<PSColor>)layerColor;
- (void)drawClickPoint: (NSPoint *)p onCanvas: (GyveCanvas *)canvas;
- (void)eraseClickPoint: (NSPoint *)p onCanvas: (GyveCanvas *)canvas;
@end

#endif /* Not def: GYVE_TOOL_H */
