/* GyveView.h --- The definition for gyve view

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_VIEW_H
#define GYVE_VIEW_H 

#include <gyve/constant.h>

#include <objc/objc-api.h>
#include <DPS/dpsfriends.h>
#include <Foundation/NSObject.h>
#include <Foundation/NSGeometry.h>

#include <gdk/gdktypes.h>

#include <gyve/geometry.h>

/*
 * GyveView
 *
 * GyveView$B$O(B, GyveDrawingEngine$B$rMQ$$$FIA2h$9$k$?$a$N!V;f!W$rDs6!$9$k(B. 
 * $B<B:]$KIA2h$9$k$K$O(B, $B%Z%s$H$7$F(BGyveDrawingEngine$B$N%W%m%H%3%k$rK~$9(B
 * $B%*%V%8%'%/%H$,I,MW$G$"$k(B. GyveView$B$N@_7W$K$*$$$F$O(B, 
 * GyveDrawingEngine$B$,$I$N$h$&$J;f$,<+J,$N=PNO@h$K$J$C$F$$$k$+CN$k(B
 * $BI,MW$,$J$$$h$&EXNO$7$?(B. 
 *
 * GyveView$B$NLr3d(B:
 * +  $B:FIA2h$9$kI,MW$N$"$kNN0h$r(BGyveDrawingEngine$B$K9pCN$9$k(B. 
 * +  $BIA2hNN0h$N%5%$%:$N4IM}(B
 *  
 * $BI=<(4XO"$N%/%i%9$O(Bgyve-0.1.x$B$N$b$N$r$=$N$^$^;H$&(B. 
 * $B$3$NItJ,$N2~NI$K$O(BgtkDPS-hige$B$NEP>l$rBT$DI,MW$,$"$k(B. 
 */

#include <gtk/gtk.h>
#include <Foundation/NSGeometry.h>
#include <Foundation/NSObject.h>
#include <gyve/GyveDrawingEngine.h>
#include <gyve/PSBBox.h>
#include <gyve/GyveGUI.h>

@class NSString;
extern NSString * GyveViewWrongGdkEventToTranslate;

@interface GyveView: GyveGUI
{
  NSObject<GyveDrawingEngine> * drawing_engine;
  struct coord_tr coord_tr;
  NSSize document_size_x;
@private
  /* redraw_lock_depth$B$,(B0$B$N>l9g$N$_(B redraw$B$r<B9T$9$k(B. 
     $B$^$?(B redraw_lock_depth > 0 $B$N>l9g$r(B redraw$B$,%m%C%/$5$l$F$$$k(B
     $B$H8@$&(B. redraw$B$,%m%C%/$5$l$F$$$k4V$KFO$/(Bredraw$BL?Na$KBP$7$F$O(B, 
     redraw$B$9$kNN0h$N3HD%$N$_$r9T$J$$(B, $B<B:]$K$O(B, redraw$B$r$7$J$$(B. 
     $B>-Mh(B redraw_lock_depth == 0$B$K$J$C$?$H$-$K(B, $B0lEY$K(B($B3HD%$rB3$1$F$-$?(B
     $BNN0h$r(Bredraw$B$9$k(B. 
     -redrawLockRetain $B$K$h$j(B redraw_lock_depth$B$rA}2C$5$;$k$3$H$,$G$-(B, 
     -redrawLockRelease$B$K$h$j(B redraw_lock_depth$B$r8:>/$5$;$k$3$H$,$G$-$k(B. */
  int redraw_lock_depth;
  
  /* GdkEventExpose$B$,O"B3$7$FE~Ce$9$k>l9g(B, redraw$B$;$:$K(B, 
     redraw$BNN0h$N7W;;$N$_$r3HD%$7B3$1$k(B.
     
     $BO"B3$7$FFO$$$?%$%Y%s%H$N:G8e$N%$%Y%s%H$,E~Ce$7$?$H$-(B, 
     $B7W;;$r$7$F3HD%$rB3$1$?NN0h$N(Bredraw$B$r9T$J$&(B. $B$?$@$7(B 
     redraw_lock_depth$B$NCM$K$h$C$F(B, redraw$B$,CY1d$5$l$k$3$H$,$"$k(B. 
     
     (fixme doc)total_redraw_rect$B$K$O(B, $B$=$N7W;;$7$?NN0h$rJ]B8$9$k(B. */
  NSRect total_redraw_rect;
  BOOL receiving_expose_events_sequence;
}
// Size in X
- initWithViewWidth: (int)w_x height: (int)h_x;	
- setDrawingEngine: (NSObject<GyveDrawingEngine>*)e;
- (float)absoluteScale;
- (void)setAbsoluteScale:(float) scale;
- (void)dealloc ;
- (NSObject<GyveDrawingEngine>*)drawingEngine;
- (DPSContext)dpsContextBegin;
- (void)dpsContextEnd;
- (void)redrawAll;
- (void)redrawRect: (const NSRect *)dps_rect;
- (void)redrawRect: (const NSRect *)dps_rect expandBy: (float)delta;
- (void)redrawBBoxCStructure: (struct bbox *)dps_bbox;
- (void)redrawBBoxCStructure: (struct bbox *)dps_bbox expandBy: (float)delta;
- (void)redrawBBox: (id<PSBBox>)dps_bboxobj; 
- (void)redrawBBox: (id<PSBBox>)dps_bboxobj expandBy: (float)delta;
- (void)redrawFigObj: (id<PSFigObj>)figobj;// Auto expanding
- redrawLockRetain;
- (void)redrawLockRelease;
- (int)redrawLockCount;
- (void)enableImageCache;
- (void)disableImageCache;

// Throws GyveViewWrongGdkEventToTranslate
- (NSPoint)translatePointFromXToDPS: (NSPoint *)point_x;
- (NSRect)translateRectFromXToDPS: (NSRect *)rect_x;
- (NSSize)translateSizeFromXToDPS: (NSSize *)size_x;
- (NSPoint)translatePointFromGdkEventToDPS: (GdkEvent *)event;
- (NSSize)dpsAreaSize;	// Current view size in DPS coords
- (NSSize)dpsAreaSizeInX;	// Current view size in X coords
- (NSSize)documentSize;		// Document size in DPS coords
- (NSSize)documentSizeInX;	// Document size in X coords
@end

@interface GyveView(Protected)
- (void)changeAreaSizeWidth: (int)w_x height: (int)h_x;
- (void)setXoffsetX: (int)x_x Y: (int)y_x;
- (void)updateCoordTr;
- (void)setupSignalHandler;
- (void)exposeEvent: (GdkEventExpose*)e;
- (void)enterContextNotify: (DPSContext)ctxt;
- (GtkWidget *)dpsAreaWidget;
- (void)calcDocumentSize;
- (BOOL)calcBBoxOfFigObj: (id<PSFigObj>)figobj;
@end

#endif /* Not def: GYVE_VIEW_H */
