/* GyveVisitor.h --- Automatic function applier to the figobj in any container

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_VISITOR_H
#define GYVE_VISITOR_H 

#include <gyve/utilities.h>
#include <gyve/containing.h>
#include <gyve/PSText.h>
#include <gyve/GyveSelectionsLayer.h>

enum gyve_visitor_request 
{
  /*  */
  visitor_stop,
  /* ŬƱ٥ˤ륪֥ */
  visitor_continue,
  /* Ŭ**񤹤륪֥ȤΥ٥˰ư */
  visitor_detail,
  /* Ŭ**񤹤륪֥ȤΥ٥˰ư */
  visitor_rough
};

@class GyveBuffer, PSPath, PSImage;
@class PSFigObjGroup, PSMaskedFigObjGroup, PSCompoundPaths;
@class GyveBuffer;

@protocol GyveVisitor
- (void)setEnumerationFilter:(id_predicator_t *)filter;
- (void)visitDownward;		/* n n-1 ... 2 1 0: (hit detecting) */
- (void)visitUpward;		/* 0 1 2 ... n: (drawing) */
- (enum gyve_visitor_request)visitAtProxy: (PSFigObjSelectedProxy *)proxy;
- (enum gyve_visitor_request)visitAtBuffer:(GyveBuffer *)buffer;
- (enum gyve_visitor_request)visitAtLayer:(GyveLayer *)layer;
- (enum gyve_visitor_request)visitAtPath:(PSPath *)path;
- (enum gyve_visitor_request)visitAtText:(NSObject<PSText>*)text;
- (enum gyve_visitor_request)visitAtImage:(PSImage *)image;
- (enum gyve_visitor_request)visitAtFigObjGroup:(PSFigObjGroup *)group;
- (enum gyve_visitor_request)visitAtMaskedFigObjGroup:(PSMaskedFigObjGroup *)masked_group;
- (enum gyve_visitor_request)visitAtCompoundPaths: (PSCompoundPaths *)compound_paths;
- (void)leaveFromProxy: (PSFigObjSelectedProxy *)proxy;
- (void)leaveFromBuffer:(GyveBuffer *)buffer;
- (void)leaveFromLayer:(GyveLayer *)layer;
- (void)leaveFromPath:(PSPath *)path;
- (void)leaveFromText:(NSObject<PSText>*)text;
- (void)leaveFromImage:(PSImage *)image;
- (void)leaveFromFigObjGroup:(PSFigObjGroup *)group;
- (void)leaveFromMaskedFigObjGroup:(PSMaskedFigObjGroup *)masked_group;
- (void)leaveFromCompoundPaths: (PSCompoundPaths *)compound_paths;
@end

enum gyve_visitor_direction { visiting_upward, visiting_downward};

@interface GyveVisitor: NSObject<GyveVisitor>
{
  id_predicator_t * filter;
  NSObject <FigObjsContaining> * target;
  enum gyve_visitor_direction visiting_direction;
}
- initWithVisitingTarget: (NSObject <FigObjsContaining>*)target;
- (NSObject <FigObjsContaining> *)visitingTarget;
@end

@interface GyveVisitor(Protected)
- (enum gyve_visitor_request)_visitAtProxy: (PSFigObjSelectedProxy *)proxy;
- (enum gyve_visitor_request)_visitAtBuffer: (GyveBuffer *)buffer;
- (enum gyve_visitor_request)_visitAtLayer: (GyveLayer *)layer;
- (enum gyve_visitor_request)_visitAtFigObj: (id<PSFigObj>)figobj;
- (enum gyve_visitor_request)_visitAtPath: (PSPath *)path;
- (enum gyve_visitor_request)_visitAtImage: (PSImage *)image;
- (enum gyve_visitor_request)_visitAtText: (NSObject<PSText> *)text;
- (enum gyve_visitor_request)_visitAtFigObjGroup: (PSFigObjGroup *)group;
- (enum gyve_visitor_request)_visitAtMaskedFigObjGroup: (PSMaskedFigObjGroup *)masked_group;
- (enum gyve_visitor_request)_visitAtCompoundPaths: (PSCompoundPaths *)compound_paths;
- (void)visit; 
@end

@interface GyveDebugVisitor: GyveVisitor
- (enum gyve_visitor_request)visitAtBuffer:(GyveBuffer *)buffer;
- (enum gyve_visitor_request)visitAtLayer:(GyveLayer *)layer;
- (enum gyve_visitor_request)visitAtPath:(PSPath *)path;
- (enum gyve_visitor_request)visitAtText:(NSObject<PSText>*)text;
- (enum gyve_visitor_request)visitAtImage:(PSImage *)image;
- (enum gyve_visitor_request)visitAtFigObjGroup:(PSFigObjGroup *)group;
- (enum gyve_visitor_request)visitAtMaskedFigObjGroup:(PSMaskedFigObjGroup *)masked_group;
- (enum gyve_visitor_request)visitAtCompoundPaths: (PSCompoundPaths *)compound_paths;
@end

#endif /* Not def: GYVE_VISITOR_H */
