/* GyveWindow.h --- The definition for top level document window

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_WINDOW_H
#define GYVE_WINDOW_H 

#include <gyve/GyveDrawingEngine.h>
#include <gyve/GyveEventHandler.h>
#include <gyve/GyveGUI.h>

@class GyveBuffer, NSString, NSSet;

@interface GyveWindow: GyveGUI
{
  GyveCanvas * canvas;
  GyveBuffer * buffer;
@private
  int window_ID;
}
/* 
 * ID 
 */
+ (int)issueWindowIDFor: (GyveWindow *)window;
+ (GyveWindow *)windowFromID:(int)windowID;
+ (void)setCurrentWindow:(GyveWindow *)window; 
+ (GyveWindow * )currentWindow;
+ (void)setLastClickedWindow:(GyveWindow *)window; 
+ (GyveWindow * )lastClickedWindow;
+ (GyveWindow *)lookUpWindowByCanvas:(GyveCanvas *)_canvas;
+ (NSSet *)lookUpWindowByBuffer: (GyveBuffer * )buffer;
- (int)windowID;

- initWithBuffer: (GyveBuffer *)b;
- (void)dealloc;
- (GyveBuffer *)contentBuffer;
- (GyveCanvas *)contentCanvas;
- (void)setTitle:(NSString *)title;
- (void)show;
- (void)becomeCurrentWindow;
// Redraw
/* redraw_lock_depth0ξΤ redraw¹Ԥ. 
   ޤ redraw_lock_depth > 0 ξ redrawåƤ
   ȸ. redrawåƤ֤Ϥredraw̿ФƤ, 
   redrawΰγĥΤߤԤʤ, ºݤˤ, redraw򤷤ʤ. 
   -redrawLockReleaseˤ
    redraw_lock_depth == 0ˤʤäȤ, ٤(ĥ³Ƥ
   ΰredraw. 
   -redrawLockRetain ˤ redraw_lock_depthä뤳ȤǤ, 
   -redrawLockReleaseˤ redraw_lock_depth򸺾뤳ȤǤ. */
- (void)redrawAll;
- redrawLockRetain;
- (void)redrawLockRelease;
- (void)redrawFigObj: (id<PSFigObj>)figobj;
- (void)redrawBBox: (id<PSBBox>)dps_bboxobj; 
- (void)redrawBBox: (id<PSBBox>)dps_bboxobj expandBy: (float)delta;
- (void)redrawRect: (NSRect *)rect;
@end
#endif /* Not def: GYVE_WINDOW_H */
