/* LayersPallet.h --- layers pallet wrappper
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef GYVE_LAYERS_PALLET_H
#define GYVE_LAYERS_PALLET_H 

#include <gyve/GyveGUI.h>
#include <gtk/gtk.h>

@class GyveBuffer, GyveLayer, BuffersMenu;
@interface LayersPallet: GyveGUI
{ 
  GyveBuffer * current_buffer;
  GyveLayer * current_layer;
  GtkWidget * layers_box;
  GtkWidget * layers_menu;
  BuffersMenu * buffers_menu;
}
+ (GyveGUI *)sharedObject;
+ (LayersPallet *)layersPallet;
- init;
@end
void layers_pallet_show();
void layers_pallet_hide();
LayersPallet * layers_pallet();
#endif /* Not def: GYVE_LAYERS_PALLET_H */
