/* LayersPallet.m --- layers pallet wrappper
   
   Copyright (C) 1998 Free Software Foundation, Inc.
   
   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "LayersPallet.h"
#include "layers_pallet.h"
#include "GyveBuffer.h"

@implementation LayersPallet
static LayersPallet * shared_layers_pallet = nil;
+ (GyveGUI *)sharedObject
{
  if (nil == shared_layers_pallet)
    shared_layers_pallet = [[self alloc] init];
  return shared_layers_pallet;
}
+ (LayersPallet *)layersPallet
{
  return (LayersPallet *)[self sharedObject];
}
- init
{
  [super init];
  
  buffers_menu = nil;
  widget = layers_pallet_new((struct layers_pallet *)self);
  [buffers_menu retain];
  return self ;
}
- (void)dealloc
{
  [buffers_menu release];
  [super dealloc];
}
@end

void layers_pallet_show()
{
  [[LayersPallet layersPallet] show];
}
void layers_pallet_hide()
{
  [[LayersPallet layersPallet] hide];
}

LayersPallet * layers_pallet()
{
  return [LayersPallet layersPallet];
}
