/* PSBBox.h --- Protocol for BBox

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_B_BOX_H
#define P_S_B_BOX_H 

// #include <gyve/constant.h>
#include <gyve/geometry.h>
#include <Foundation/NSValue.h>
#include <Foundation/NSConcreteValue.h>

/* MEMO: @protocol PSBBox 

   PSBBoxΰĥ֥Ȥ٤Ǥ. 

   ޷褹Ȥ, ο޷ɤΰ뤫Τ뤳ȤǤ
   , ΰ򶹤뤳ȤǤ. , gyveǤ, ޷ڤӤ
   ݻ륯饹Υ֥Ȥ, 줾켫Ȥΰ
   褦ˤƤ.

   PSBBox˽Ȥˤ, ΰγη׻ñˤʤ. */

#define SAMPLE_CODE 0

@protocol PSBBox
- (void)calcBBox;
- (struct bbox *)bboxCStructure;
- (void)zeroBBox;
#if SAMPLE_CODE
{
  bbox_copy(&zero_bbox, [self bboxCStructure]);
}
#endif /* SAMPLE_CODE */

- (BOOL)isZeroBBox;
#if SAMPLE_CODE
{
  return bbox_is_zero_bbox([self bboxCStructure]);
}
#endif /* SAMPLE_CODE */

- (BOOL)expandBBoxByBBox: (id<PSBBox>)b;
#if SAMPLE_CODE
{
  return bbox_expand_by_bbox([self bboxCStructure], [b bboxCStructure]);
}
#endif /* SAMPLE_CODE */

- (void)reportBBoxTo: (id<PSBBox>)b ;
#if SAMPLE_CODE
{
  [b expandBBoxByBBox: self];
}
#endif  /* SAMPLE_CODE */

- (BOOL)isPointInBBox: (NSPoint *)p;
#if SAMPLE_CODE
{
  return bbox_contains_point([self bboxCStructure], p);
}
#endif /* SAMPLE_CODE */

- (BOOL)intersectsWithBBox: (id<PSBBox>)b;
#if SAMPLE_CODE
{
  return bbox_intersects([self bboxCStructure], [b bboxCStructure]);
}
#endif /* SAMPLE_CODE */
- (BOOL)intersectsWithRect: (NSRect *)r;
#if SAMPLE_CODE
{
  struct bbox b;
  NSRect_to_bbox (r, &b);
  return bbox_intersects([self bboxCStructure], &b);
}
#endif /* SAMPLE_CODE */
@end

@interface NSValue(PSBBox)
+ (NSValue *)valueWithBBox: (struct bbox *)b;
- (struct bbox *)bboxValue;
- (float)bboxValueLLX;
- (float)bboxValueLLY;
- (float)bboxValueURX;
- (float)bboxValueURY;
@end

@interface PSBBox: NSConcreteValue<PSBBox>
- initWithBBox: (struct bbox *)b;
- initWithBBoxElementLLX: (float)llx
		     LLY: (float)lly
		     URX: (float)urx
		     URY: (float)ury;
@end 

#undef SAMPLE_CODE 
#endif /* Not def: P_S_B_BOX_H */

