/* PSBBox.m --- objc representation of bbox c structure

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSBBox.h"

@implementation  PSBBox
- initWithBBox: (struct bbox *)b
{
  [super initValue: b withObjCType:  @encode(struct bbox *)];
  return self ;
}
- initWithBBoxElementLLX: (float)llx LLY: (float)lly 
		     URX: (float)urx URY: (float)ury
{
  struct bbox b;
  b.lower_left.x  = llx;
  b.lower_left.y  = lly;
  b.upper_right.x = urx;
  b.upper_right.y = ury;
  return [self initWithBBox: &b];
}
- (void)calcBBox {}		// Do nothing
- (struct bbox *)bboxCStructure 
{
  return (struct bbox *)data;
}
- (void)zeroBBox
{
  bbox_copy(&zero_bbox, (struct bbox *)[self bboxCStructure]);
}
- (BOOL)isZeroBBox
{
  return bbox_is_zero_bbox([self bboxCStructure]);
}
- (BOOL)expandBBoxByBBox: (id<PSBBox>)b
{
  return bbox_expand_by_bbox([self bboxCStructure], 
			     [b bboxCStructure]);
}
- (void)reportBBoxTo: (id<PSBBox>)b 
{
  [b expandBBoxByBBox: self];
}
- (BOOL)isPointInBBox: (NSPoint *)p;
{
  return bbox_contains_point([self bboxCStructure], p);
}

- (BOOL)intersectsWithBBox: (id<PSBBox>)b;
{
  return bbox_intersects([self bboxCStructure], [b bboxCStructure]);
}
- (struct bbox *)bboxValue
{
  return (struct bbox *)data;
}
- (BOOL)intersectsWithRect: (NSRect *)r
{
  struct bbox b;
  NSRect_to_bbox (r, &b);
  return bbox_intersects([self bboxCStructure], &b);
}
@end

@implementation NSValue(PSBBox)
+ (NSValue *)valueWithBBox: (struct bbox *)b
{
  return [[[PSBBox alloc] initWithBBox: b] autorelease];
}
- (struct bbox *)bboxValue
{
  return NULL;
}
- (float)bboxValueLLX
{
  return [self bboxValue]->lower_left.x;
}
- (float)bboxValueLLY
{
  return [self bboxValue]->lower_left.y;
}
- (float)bboxValueURX
{
  return [self bboxValue]->upper_right.x;
}
- (float)bboxValueURY
{
  return [self bboxValue]->upper_right.y;
}
@end

