/* PSColor.m  --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSColor.h"
#include "utilities.h"

void
color_init_as_white(struct color * color)
{
  color->red = 1.0;
  color->green = 1.0;
  color->blue = 1.0;
}

void
color_init_as_black(struct color * color)
{
  color->red = 0.0;
  color->green = 0.0;
  color->blue = 0.0;
} 

float
color_element_round(float elt)
{
  NSRange range;
  range.location = 0.0;
  range.length   = 1.0;
  return NSRange_round_by_range(&range, elt);
}

static unsigned char color_char_max = 255;
float
color_element_from_char(unsigned char c)
{
#define floatfy_color(c) (((float)c)/((float)color_char_max))
  return floatfy_color(c);
#undef floatfy_color
}
