/* PSCustomColor.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_CUSTOM_COLOR_H
#define P_S_CUSTOM_COLOR_H 
#include <gyve/utilities.h>
#include <gyve/PSProcessColor.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSString.h>

/* TODO: Painting Dictionary
   Looking up the Document local dictionary first.
   Looking up the Gyve application global dictionary second... */

@interface PSCustomColor: NSObject<NSCopying, PSColor>
{
  NSString * name;
}
+ (PSCustomColor *)customColorWithName: (BYCOPY NSString *)_name;
- initWithName: (BYCOPY NSString *)_name;
- copyWithZone: (NSZone *)zone;
- (void)dealloc;
- (NSString *)customColorName;
@end

@protocol PSCustomColorDictionary
- (void)setColor: (BYREF PSProcessColor *) color forName: (BYREF NSString *)name;
- (PSProcessColor *)colorForName: (NSString *)name;
- (PSProcessColor *)colorForCustomColor: (PSCustomColor *)custom_color;
@end

@interface NSMutableDictionary(PSCustomColorDictionary)
- (void)setColor: (BYREF PSProcessColor *) color forName: (BYREF NSString *)name;
- (PSProcessColor *)colorForName: (NSString *)name;
- (PSProcessColor *)colorForCustomColor: (PSCustomColor *)custom_color;
@end

@interface PSCustomColorDictionary: NSMutableDictionary<PSCustomColorDictionary>
- (void)setColor: (BYREF PSProcessColor *) color forName: (BYREF NSString *)name;
- (PSProcessColor *)colorForName: (NSString *)name;
- (PSProcessColor *)colorForCustomColor: (PSCustomColor *)custom_color;
@end

#endif /* Not def: P_S_CUSTOM_COLOR_H */
