/* PSCustomColor.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSCustomColor.h"
#include "PaintStylePallet.h"

@implementation PSCustomColor
+ (PSCustomColor *)customColorWithName: (BYCOPY NSString *)_name
{
  return [[[self alloc] initWithName: _name] autorelease];
}
- initWithName: (BYCOPY NSString *)_name
{
  [super init];
  name = [_name copy];
  return self;
}
- copyWithZone: (NSZone *)zone
{
  return [[[self class] allocWithZone: zone] initWithName: [self customColorName]];
}
- (void)dealloc
{
  [name release], name = nil;
  [super dealloc];
}
- (NSString *)customColorName
{
  return name;
}
- (float)red
{
  return [[[PaintStylePallet paintStylePallet] colorForCustomColor: self] red];
}
- (float)green
{
  return [[[PaintStylePallet paintStylePallet] colorForCustomColor: self] green];
}
- (float)blue
{
  return [[[PaintStylePallet paintStylePallet] colorForCustomColor: self] blue];
}
@end

@implementation NSMutableDictionary(PSCustomColorDictionary)
- (void)setColor: (BYREF PSProcessColor *) color forName: (BYREF NSString *)name
{
  [self setObject: color forKey: name];
}
- (PSProcessColor *)colorForName: (NSString *)name
{
  return (PSProcessColor *)[self objectForKey: name];
}
- (PSProcessColor *)colorForCustomColor: (PSCustomColor *)custom_color
{
  return [self colorForName: [custom_color customColorName]];
}
@end

@implementation PSCustomColorDictionary
- (void)setColor: (BYREF PSProcessColor *) color forName: (BYREF NSString *)name
{
  [super setColor: color forName: name];
}
- (PSProcessColor *)colorForName: (NSString *)name
{
  return [super colorForName: name];
}
- (PSProcessColor *)colorForCustomColor: (PSCustomColor *)custom_color
{
  return [super colorForCustomColor: custom_color];
}
@end
