/* PSFigObj.m --- protocol for general figure objects

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSFigObj.h"
#include <stdio.h>

@implementation PSFigObjProxy
+ proxyForFigObj: (NSObject<PSFigObj> *)figobj
{
  return [[[self alloc] initForFigObj: figobj] autorelease];
}
- initForFigObj: (NSObject<PSFigObj> *)figobj
{
  [super init];
  target = [figobj retain];
  return self;
}
- (void)dealloc
{
  [target release], target = nil;
  [super dealloc];
}
- (BOOL)isFigObjProxy
{
  return YES;
}
- (id<PSFigObj>)targetForFigObjProxy
{
  return  (id<PSFigObj>)target;
}
- (void)setTargetForFigObjProxy: (NSObject<PSFigObj> *)newfig
{
  if (newfig && (newfig != target))
    {
      if (target) [target autorelease];
      target = [newfig retain];
    }
}
- (void)calcBBox
{
  [target calcBBox];
}
- (struct bbox *)bboxCStructure
{
  struct bbox * bbox = [target bboxCStructure];
  return bbox;
}
- (void)zeroBBox
{
  [target zeroBBox];
}
- (BOOL)isZeroBBox
{
  return [target isZeroBBox];
}
- (BOOL)expandBBoxByBBox: (id<PSBBox>)b
{
  return [target expandBBoxByBBox: b];
}
- (void)reportBBoxTo: (id<PSBBox>)b
{
  [target reportBBoxTo: b];
}
- copyWithZone: (NSZone *)zone
{
  NSObject<PSFigObj> * copy_target =  [[target copyWithZone: zone] autorelease];
  return [[[self class] allocWithZone: zone] initForFigObj: copy_target];
}
- markAsSelected
{
  (void)[target markAsSelected];
  return self ;
}
- (BOOL)isSelected
{
  return [target isSelected];
}
- (void)unMarkAsSelected
{
  [target unMarkAsSelected];
}
- (BOOL)isPointInBBox: (NSPoint *)p;
{
  return bbox_contains_point([self bboxCStructure], p);
}
- (BOOL)intersectsWithBBox: (id<PSBBox>)b;
{
  return bbox_intersects([self bboxCStructure], [b bboxCStructure]);
}
- (BOOL)isLockedFigObj
{
  return [target isLockedFigObj];
}
- (void)setFigObjLock: (BOOL)l
{
  [target setFigObjLock: l];
}
- (BOOL)intersectsWithRect: (NSRect *)r;
{
  return [target intersectsWithRect: r];
}
- (float)deltaForExpandingBBox
{
  return [target deltaForExpandingBBox];
}
- (Class)selectedProxyClass
{
  return Nil; 
}
@end
