/* PSFigObjGroup.h --- group of figure objects

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_FIG_OBJ_GROUP_H
#define P_S_FIG_OBJ_GROUP_H 

#include <Foundation/NSArray.h>
#include <gyve/PSFigObj.h>
#include <gyve/containing.h>
#include <gyve/enumerating.h>

/*        drawing  ->
   index of Array: 0 1 2 3 ... n
                 bottom       top 
		              <- figure object writing down 
                                 hit detection */

@interface PSFigObjGroup: GyveArray <PSFigObj, FigObjsContaining>
{
  struct bbox bbox;
  BOOL locked;
  BOOL selected;
}
// Creating and destroying
- init;
- (void)dealloc;
- copyWithZone: (NSZone *)zone;

// BBox
- (void)calcBBox;
- (struct bbox *)bboxCStructure;
- (void)zeroBBox;
- (BOOL)isZeroBBox;
- (BOOL)expandBBoxByBBox: (id<PSBBox>)b;
- (void)reportBBoxTo: (id<PSBBox>)b ;
- (BOOL)isPointInBBox: (NSPoint *)p;
- (BOOL)intersectsWithBBox: (id<PSBBox>)b;
- (BOOL)intersectsWithRect: (NSRect *)r;

// FigObj protocol 
- (BOOL)isFigObjProxy;
- (NSObject<PSFigObj> *)targetForFigObjProxy;
- markAsSelected;
- (BOOL)isSelected;
- (void)unMarkAsSelected;
- (BOOL)isLockedFigObj;
- (void)setFigObjLock: (BOOL)l;

// FigObj containing protocol 
- (id<PSFigObj>)firstPrimitiveFigObj;
- (id<PSFigObj>)lastPrimitiveFigObj;
- (id<PSFigObj>)firstFigObj;
- (id<PSFigObj>)lastFigObj;
- (BOOL)containsFigObj: (id<PSFigObj>)figobj;
- (int)countFigObjs;
- (id<PSFigObj>)figObjAtIndex: (int)n;
- (int)indexOfFigObj: (id<PSFigObj>)figobj;
- (void)addFigObj: (NSObject<PSFigObj> *)figobj;
- (id<FigObjsEnumerating>)figObjsEnumerator;
- (id<FigObjsEnumerating>)reverseFigObjsEnumerator;
- (id<FigObjsPrimitiveEnumerating>)primitiveFigObjsEnumerator;
- (id<FigObjsPrimitiveEnumerating>)reversePrimitiveFigObjsEnumerator;
@end

#endif /* Not def: P_S_FIG_OBJ_GROUP_H */
