/* PSGradation.h --- 

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_GRADATION_H
#define P_S_GRADATION_H 

@interface PSGradationSegment: NSObject<NSCopying>
{
  PSProcessColor color;
  float start;
  float middle;
}
@end

@interface PSGradation: GyveArray<NSCopying>
@end

@interface PSGradationOption: PSMatrix
@end

@protocol PSGradationDictionary
- (void)setGradation: (BYREF PSGradation *) color forName: (BYREF NSString *)name;
- (PSGradation *)GradationForName: (NSString *)name;
- (PSGradation *)GradationForGradationOption: (PSGradationOption *)opt;
@end

@interface NSMutableDictionary(PSGradationDictionary)
- (void)setGradation: (BYREF PSGradation *) Gradation forName: (BYREF NSString *)name;
- (PSGradation *)GradationForName: (NSString *)name;
- (PSGradation *)GradationForGradationOption: (PSGradationOption *)opt;
@end

@interface PSGradationDictionary: NSMutableDictionary<PSGradationDictionary>
- (void)setGradation: (BYREF PSGradation *) Gradation forName: (BYREF NSString *)name;
- (PSGradation *)GradationForName: (NSString *)name;
- (PSGradation *)GradationForGradationOption: (PSGradationOption *)opt;
@end

#endif /* Not def: P_S_GRADATION_H */
