/* PSImage.h --- Image object

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#ifndef P_S_IMAGE_H
#define P_S_IMAGE_H 

#include <Foundation/NSData.h>
#include <gyve/PSFigObj.h>
#include <gyve/dps.h>

@class NSValue, PSMatrix;

// 
@interface	NSMutableDataMalloc : NSMutableData
{
  unsigned	length;
  void		*bytes;
  NSZone	*zone;
  unsigned	capacity;
  unsigned	growth;
}
@end

/* 2 2 8 [99 0 0 -99 0 8] (00f00f00f00f) false 3 colorimage 
   w h const mapping_matrix   bytes         const const const */
@interface PSImage: NSMutableDataMalloc<PSFigObj, PSUserObject>
{
  int width, height;
  float mapping_matrix[6];
  struct bbox bbox;
  BOOL selected;
  BOOL locked;
}
+ randomImageWithWidth: (int)w height: (int)h;
+ imageFromXpmFile: (char *)file_name;
- initWithWidth: (int)w height: (int)h pixels: (unsigned char*) pixels;
- (BOOL) isEqual: anObject;
- (int)imageWidth;
- (int)imageHeight;
- (float *)mappingMatrix;
- (void)setMappingMatrix: (float *)new_mapping_matrix;

//
- (BOOL)isFigObjProxy;
- (NSObject<PSFigObj> *)targetForFigObjProxy;
- markAsSelected;
- (BOOL)isSelected;
- (void)unMarkAsSelected;
- (BOOL)isLockedFigObj;
- (void)setFigObjLock: (BOOL)l;
//
- (unsigned char *)mutablePixelsOfLine: (int)line;// zero origin
- (unsigned char *)mutablePixelInLine: (int)line column: (int)column;
//
- (void)bindToUserobject: (userobject)i inContext:(DPSContext)ctxt;
- (userobject)userobject;
@end

@interface PSImage(Guile)
- (void)setMappingMatrixValue: (NSValue *) matrix;
- (PSMatrix *)mappingMatrixValue;
@end
#endif /* Not def: P_S_IMAGE_H */
