/* PSMaskedFigObjGroup.h --- group with mask

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
   
   This file is part of the GNU Yellow Vector Editor

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */ 

#include "PSMaskedFigObjGroup.h"
#include "PSPath.h"
#include "PSFigObj.h"

@implementation PSMaskedFigObjGroup: PSFigObjGroup
- init
{
  [self shouldNotImplement:_cmd];
  return nil;
}
- initWithMaskPath: (PSPath *) p
{
  mask_path = [p retain];
  [super init];
  [self calcBBox];
  return self ;
}
- (PSPath *)maskPath
{
  return mask_path;
}
- (void)setMaskPath: (PSPath *)newpath
{
  [mask_path release];
  mask_path = [newpath retain];
  [self calcBBox];
}
- (void)calcBBox
{
  [super calcBBox];
  [self expandBBoxByBBox: mask_path];
}
- copyWithZone: (NSZone *)zone
{
  PSPath * mask = [[[self maskPath] copyWithZone: zone] autorelease];
  PSMaskedFigObjGroup * new_mask =  [[[self class] allocWithZone: zone]
				      initWithMaskPath: mask];
  NSObject <PSFigObj> * figobj;
  int i, max;
  max = [self countFigObjs];
  for (i = 0; i < max; i++)
    {
      figobj = [self figObjAtIndex: i];
      [new_mask appendObject: [[figobj copyWithZone: zone] autorelease]];
    }
  [new_mask calcBBox];
  return new_mask;
}
- (void)dealloc
{
  [mask_path release];
  [super dealloc];
}
@end
